/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.network.packet;

import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.network.NetHandler;
import com.mojang.minecraft.network.packet.Packet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Packet103SetSlot
extends Packet {
    public int windowId;
    public int itemSlot;
    public ItemStack myItemStack;

    public Packet103SetSlot() {
    }

    public Packet103SetSlot(int i, int j, ItemStack itemstack) {
        this.windowId = i;
        this.itemSlot = j;
        this.myItemStack = itemstack != null ? itemstack.copy() : itemstack;
    }

    public void processPacket(NetHandler nethandler) {
        nethandler.func_20003_a(this);
    }

    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.windowId = datainputstream.readByte();
        this.itemSlot = datainputstream.readShort();
        short word0 = datainputstream.readShort();
        if (word0 >= 0) {
            byte byte0 = datainputstream.readByte();
            short word1 = datainputstream.readShort();
            this.myItemStack = new ItemStack(word0, (int)byte0, (int)word1);
        } else {
            this.myItemStack = null;
        }
    }

    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeByte(this.windowId);
        dataoutputstream.writeShort(this.itemSlot);
        if (this.myItemStack == null) {
            dataoutputstream.writeShort(-1);
        } else {
            dataoutputstream.writeShort(this.myItemStack.itemID);
            dataoutputstream.writeByte(this.myItemStack.stackSize);
            dataoutputstream.writeShort(this.myItemStack.getItemDamage());
        }
    }

    public int getPacketSize() {
        return 8;
    }
}

