/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.network.packet;

import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.network.NetHandler;
import com.mojang.minecraft.network.packet.Packet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

public class Packet104WindowItems
extends Packet {
    public int windowId;
    public ItemStack[] itemStack;

    public Packet104WindowItems() {
    }

    public Packet104WindowItems(int i, List list) {
        this.windowId = i;
        this.itemStack = new ItemStack[list.size()];
        int j = 0;
        while (j < this.itemStack.length) {
            ItemStack itemstack = (ItemStack)list.get(j);
            this.itemStack[j] = itemstack != null ? itemstack.copy() : null;
            ++j;
        }
    }

    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.windowId = datainputstream.readByte();
        int word0 = datainputstream.readShort();
        this.itemStack = new ItemStack[word0];
        int i = 0;
        while (i < word0) {
            short word1 = datainputstream.readShort();
            if (word1 >= 0) {
                byte byte0 = datainputstream.readByte();
                short word2 = datainputstream.readShort();
                this.itemStack[i] = new ItemStack(word1, (int)byte0, (int)word2);
            }
            ++i;
        }
    }

    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeByte(this.windowId);
        dataoutputstream.writeShort(this.itemStack.length);
        int i = 0;
        while (i < this.itemStack.length) {
            if (this.itemStack[i] == null) {
                dataoutputstream.writeShort(-1);
            } else {
                dataoutputstream.writeShort((short)this.itemStack[i].itemID);
                dataoutputstream.writeByte((byte)this.itemStack[i].stackSize);
                dataoutputstream.writeShort((short)this.itemStack[i].getItemDamage());
            }
            ++i;
        }
    }

    public void processPacket(NetHandler nethandler) {
        nethandler.func_20001_a(this);
    }

    public int getPacketSize() {
        return 3 + this.itemStack.length * 5;
    }
}

