/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.network.packet;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.network.NetHandler;
import com.mojang.minecraft.network.packet.Packet;
import com.mojang.minecraft.util.MathHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Packet20NamedEntitySpawn
extends Packet {
    public int entityId;
    public String name;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public byte rotation;
    public byte pitch;
    public int currentItem;

    public Packet20NamedEntitySpawn() {
    }

    public Packet20NamedEntitySpawn(EntityPlayer entityplayer) {
        this.entityId = entityplayer.entityId;
        this.name = entityplayer.username;
        this.xPosition = MathHelper.floor_double(entityplayer.posX * 32.0);
        this.yPosition = MathHelper.floor_double(entityplayer.posY * 32.0);
        this.zPosition = MathHelper.floor_double(entityplayer.posZ * 32.0);
        this.rotation = (byte)(entityplayer.rotationYaw * 256.0f / 360.0f);
        this.pitch = (byte)(entityplayer.rotationPitch * 256.0f / 360.0f);
        ItemStack itemstack = entityplayer.inventory.getCurrentItem();
        this.currentItem = itemstack != null ? itemstack.itemID : 0;
    }

    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.entityId = datainputstream.readInt();
        this.name = Packet20NamedEntitySpawn.readString(datainputstream, 16);
        this.xPosition = datainputstream.readInt();
        this.yPosition = datainputstream.readInt();
        this.zPosition = datainputstream.readInt();
        this.rotation = datainputstream.readByte();
        this.pitch = datainputstream.readByte();
        this.currentItem = datainputstream.readShort();
    }

    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeInt(this.entityId);
        Packet20NamedEntitySpawn.writeString(this.name, dataoutputstream);
        dataoutputstream.writeInt(this.xPosition);
        dataoutputstream.writeInt(this.yPosition);
        dataoutputstream.writeInt(this.zPosition);
        dataoutputstream.writeByte(this.rotation);
        dataoutputstream.writeByte(this.pitch);
        dataoutputstream.writeShort(this.currentItem);
    }

    public void processPacket(NetHandler nethandler) {
        nethandler.handleNamedEntitySpawn(this);
    }

    public int getPacketSize() {
        return 28;
    }
}

