/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.network.packet;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.network.NetHandler;
import com.mojang.minecraft.network.packet.Packet;
import com.mojang.minecraft.util.MathHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Packet23VehicleSpawn
extends Packet {
    public int entityId;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public int field_28044_e;
    public int field_28043_f;
    public int field_28042_g;
    public int type;
    public int field_28041_i;

    public Packet23VehicleSpawn() {
    }

    public Packet23VehicleSpawn(Entity entity, int i) {
        this(entity, i, 0);
    }

    public Packet23VehicleSpawn(Entity entity, int i, int j) {
        this.entityId = entity.entityId;
        this.xPosition = MathHelper.floor_double(entity.posX * 32.0);
        this.yPosition = MathHelper.floor_double(entity.posY * 32.0);
        this.zPosition = MathHelper.floor_double(entity.posZ * 32.0);
        this.type = i;
        this.field_28041_i = j;
        if (j > 0) {
            double d = entity.motionX;
            double d1 = entity.motionY;
            double d2 = entity.motionZ;
            double d3 = 3.9;
            if (d < -d3) {
                d = -d3;
            }
            if (d1 < -d3) {
                d1 = -d3;
            }
            if (d2 < -d3) {
                d2 = -d3;
            }
            if (d > d3) {
                d = d3;
            }
            if (d1 > d3) {
                d1 = d3;
            }
            if (d2 > d3) {
                d2 = d3;
            }
            this.field_28044_e = (int)(d * 8000.0);
            this.field_28043_f = (int)(d1 * 8000.0);
            this.field_28042_g = (int)(d2 * 8000.0);
        }
    }

    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.entityId = datainputstream.readInt();
        this.type = datainputstream.readByte();
        this.xPosition = datainputstream.readInt();
        this.yPosition = datainputstream.readInt();
        this.zPosition = datainputstream.readInt();
        this.field_28041_i = datainputstream.readInt();
        if (this.field_28041_i > 0) {
            this.field_28044_e = datainputstream.readShort();
            this.field_28043_f = datainputstream.readShort();
            this.field_28042_g = datainputstream.readShort();
        }
    }

    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeInt(this.entityId);
        dataoutputstream.writeByte(this.type);
        dataoutputstream.writeInt(this.xPosition);
        dataoutputstream.writeInt(this.yPosition);
        dataoutputstream.writeInt(this.zPosition);
        dataoutputstream.writeInt(this.field_28041_i);
        if (this.field_28041_i > 0) {
            dataoutputstream.writeShort(this.field_28044_e);
            dataoutputstream.writeShort(this.field_28043_f);
            dataoutputstream.writeShort(this.field_28042_g);
        }
    }

    public void processPacket(NetHandler nethandler) {
        nethandler.handleVehicleSpawn(this);
    }

    public int getPacketSize() {
        return 21 + this.field_28041_i <= 0 ? 0 : 6;
    }
}

