/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.network.packet;

import com.mojang.minecraft.entity.EntityList;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.network.DataWatcher;
import com.mojang.minecraft.network.NetHandler;
import com.mojang.minecraft.network.packet.Packet;
import com.mojang.minecraft.util.MathHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

public class Packet24MobSpawn
extends Packet {
    public int entityId;
    public byte type;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public byte yaw;
    public byte pitch;
    private DataWatcher metaData;
    private List receivedMetadata;

    public Packet24MobSpawn() {
    }

    public Packet24MobSpawn(EntityLiving entityliving) {
        this.entityId = entityliving.entityId;
        this.type = (byte)EntityList.getEntityID(entityliving);
        this.xPosition = MathHelper.floor_double(entityliving.posX * 32.0);
        this.yPosition = MathHelper.floor_double(entityliving.posY * 32.0);
        this.zPosition = MathHelper.floor_double(entityliving.posZ * 32.0);
        this.yaw = (byte)(entityliving.rotationYaw * 256.0f / 360.0f);
        this.pitch = (byte)(entityliving.rotationPitch * 256.0f / 360.0f);
        this.metaData = entityliving.getDataWatcher();
    }

    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.entityId = datainputstream.readInt();
        this.type = datainputstream.readByte();
        this.xPosition = datainputstream.readInt();
        this.yPosition = datainputstream.readInt();
        this.zPosition = datainputstream.readInt();
        this.yaw = datainputstream.readByte();
        this.pitch = datainputstream.readByte();
        this.receivedMetadata = DataWatcher.readWatchableObjects(datainputstream);
    }

    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeInt(this.entityId);
        dataoutputstream.writeByte(this.type);
        dataoutputstream.writeInt(this.xPosition);
        dataoutputstream.writeInt(this.yPosition);
        dataoutputstream.writeInt(this.zPosition);
        dataoutputstream.writeByte(this.yaw);
        dataoutputstream.writeByte(this.pitch);
        this.metaData.writeWatchableObjects(dataoutputstream);
    }

    public void processPacket(NetHandler nethandler) {
        nethandler.handleMobSpawn(this);
    }

    public int getPacketSize() {
        return 20;
    }
}

