/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.network.packet;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.network.NetHandler;
import com.mojang.minecraft.network.packet.Packet;
import com.mojang.minecraft.util.MathHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Packet34EntityTeleport
extends Packet {
    public int entityId;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public byte yaw;
    public byte pitch;

    public Packet34EntityTeleport() {
    }

    public Packet34EntityTeleport(Entity entity) {
        this.entityId = entity.entityId;
        this.xPosition = MathHelper.floor_double(entity.posX * 32.0);
        this.yPosition = MathHelper.floor_double(entity.posY * 32.0);
        this.zPosition = MathHelper.floor_double(entity.posZ * 32.0);
        this.yaw = (byte)(entity.rotationYaw * 256.0f / 360.0f);
        this.pitch = (byte)(entity.rotationPitch * 256.0f / 360.0f);
    }

    public Packet34EntityTeleport(int i, int j, int k, int l, byte byte0, byte byte1) {
        this.entityId = i;
        this.xPosition = j;
        this.yPosition = k;
        this.zPosition = l;
        this.yaw = byte0;
        this.pitch = byte1;
    }

    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.entityId = datainputstream.readInt();
        this.xPosition = datainputstream.readInt();
        this.yPosition = datainputstream.readInt();
        this.zPosition = datainputstream.readInt();
        this.yaw = (byte)datainputstream.read();
        this.pitch = (byte)datainputstream.read();
    }

    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeInt(this.entityId);
        dataoutputstream.writeInt(this.xPosition);
        dataoutputstream.writeInt(this.yPosition);
        dataoutputstream.writeInt(this.zPosition);
        dataoutputstream.write(this.yaw);
        dataoutputstream.write(this.pitch);
    }

    public void processPacket(NetHandler nethandler) {
        nethandler.handleEntityTeleport(this);
    }

    public int getPacketSize() {
        return 34;
    }
}

