/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.network.packet;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.network.NetHandler;
import com.mojang.minecraft.network.packet.Packet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Packet52MultiBlockChange
extends Packet {
    public int xPosition;
    public int zPosition;
    public short[] coordinateArray;
    public byte[] typeArray;
    public byte[] metadataArray;
    public int size;

    public Packet52MultiBlockChange() {
        this.isChunkDataPacket = true;
    }

    public Packet52MultiBlockChange(int i, int j, short[] aword0, int k, World world) {
        this.isChunkDataPacket = true;
        this.xPosition = i;
        this.zPosition = j;
        this.size = k;
        this.coordinateArray = new short[k];
        this.typeArray = new byte[k];
        this.metadataArray = new byte[k];
        Chunk chunk = world.getChunkFromChunkCoords(i, j);
        int l = 0;
        while (l < k) {
            int i1 = aword0[l] >> 12 & 0xF;
            int j1 = aword0[l] >> 8 & 0xF;
            int k1 = aword0[l] & 0xFF;
            this.coordinateArray[l] = aword0[l];
            this.typeArray[l] = (byte)chunk.getBlockId(i1, k1, j1);
            this.metadataArray[l] = (byte)chunk.getBlockMetadata(i1, k1, j1);
            ++l;
        }
    }

    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.xPosition = datainputstream.readInt();
        this.zPosition = datainputstream.readInt();
        this.size = datainputstream.readShort() & 0xFFFF;
        this.coordinateArray = new short[this.size];
        this.typeArray = new byte[this.size];
        this.metadataArray = new byte[this.size];
        int i = 0;
        while (i < this.size) {
            this.coordinateArray[i] = datainputstream.readShort();
            ++i;
        }
        datainputstream.readFully(this.typeArray);
        datainputstream.readFully(this.metadataArray);
    }

    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeInt(this.xPosition);
        dataoutputstream.writeInt(this.zPosition);
        dataoutputstream.writeShort((short)this.size);
        int i = 0;
        while (i < this.size) {
            dataoutputstream.writeShort(this.coordinateArray[i]);
            ++i;
        }
        dataoutputstream.write(this.typeArray);
        dataoutputstream.write(this.metadataArray);
    }

    public void processPacket(NetHandler nethandler) {
        nethandler.handleMultiBlockChange(this);
    }

    public int getPacketSize() {
        return 10 + this.size * 4;
    }
}

