/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.network.packet;

import com.mojang.minecraft.level.chunk.ChunkPosition;
import com.mojang.minecraft.network.NetHandler;
import com.mojang.minecraft.network.packet.Packet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class Packet60Explosion
extends Packet {
    public double explosionX;
    public double explosionY;
    public double explosionZ;
    public float explosionSize;
    public Set destroyedBlockPositions;

    public Packet60Explosion() {
    }

    public Packet60Explosion(double d, double d1, double d2, float f, Set set) {
        this.explosionX = d;
        this.explosionY = d1;
        this.explosionZ = d2;
        this.explosionSize = f;
        this.destroyedBlockPositions = new HashSet(set);
    }

    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.explosionX = datainputstream.readDouble();
        this.explosionY = datainputstream.readDouble();
        this.explosionZ = datainputstream.readDouble();
        this.explosionSize = datainputstream.readFloat();
        int i = datainputstream.readInt();
        this.destroyedBlockPositions = new HashSet();
        int j = (int)this.explosionX;
        int k = (int)this.explosionY;
        int l = (int)this.explosionZ;
        int i1 = 0;
        while (i1 < i) {
            int j1 = datainputstream.readByte() + j;
            int k1 = datainputstream.readByte() + k;
            int l1 = datainputstream.readByte() + l;
            this.destroyedBlockPositions.add(new ChunkPosition(j1, k1, l1));
            ++i1;
        }
    }

    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeDouble(this.explosionX);
        dataoutputstream.writeDouble(this.explosionY);
        dataoutputstream.writeDouble(this.explosionZ);
        dataoutputstream.writeFloat(this.explosionSize);
        dataoutputstream.writeInt(this.destroyedBlockPositions.size());
        int i = (int)this.explosionX;
        int j = (int)this.explosionY;
        int k = (int)this.explosionZ;
        for (ChunkPosition chunkposition : this.destroyedBlockPositions) {
            int l = chunkposition.x - i;
            int i1 = chunkposition.y - j;
            int j1 = chunkposition.z - k;
            dataoutputstream.writeByte(l);
            dataoutputstream.writeByte(i1);
            dataoutputstream.writeByte(j1);
        }
    }

    public void processPacket(NetHandler nethandler) {
        nethandler.func_12001_a(this);
    }

    public int getPacketSize() {
        return 32 + this.destroyedBlockPositions.size() * 3;
    }
}

