/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.player.inventory;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.ICrafting;
import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.player.inventory.InventoryPlayer;
import com.mojang.minecraft.player.inventory.Slot;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Container {
    public List inventoryItemStacks = new ArrayList();
    public List inventorySlots = new ArrayList();
    public int windowId = 0;
    private short field_20132_a = 0;
    protected List crafters = new ArrayList();
    private Set field_20131_b = new HashSet();

    protected void addSlot(Slot slot) {
        slot.id = this.inventorySlots.size();
        this.inventorySlots.add(slot);
        this.inventoryItemStacks.add(null);
    }

    public void onCraftGuiOpened(ICrafting icrafting) {
        if (this.crafters.contains(icrafting)) {
            throw new IllegalArgumentException("Listener already listening");
        }
        this.crafters.add(icrafting);
        icrafting.updateCraftingInventory(this, this.func_28127_b());
        this.updateCraftingMatrix();
    }

    public List func_28127_b() {
        ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
        int i = 0;
        while (i < this.inventorySlots.size()) {
            arraylist.add(((Slot)this.inventorySlots.get(i)).getStack());
            ++i;
        }
        return arraylist;
    }

    public void updateCraftingMatrix() {
        int i = 0;
        while (i < this.inventorySlots.size()) {
            ItemStack itemstack = ((Slot)this.inventorySlots.get(i)).getStack();
            ItemStack itemstack1 = (ItemStack)this.inventoryItemStacks.get(i);
            if (!ItemStack.areItemStacksEqual(itemstack1, itemstack)) {
                itemstack1 = itemstack != null ? itemstack.copy() : null;
                this.inventoryItemStacks.set(i, itemstack1);
                int j = 0;
                while (j < this.crafters.size()) {
                    ((ICrafting)this.crafters.get(j)).updateCraftingInventorySlot(this, i, itemstack1);
                    ++j;
                }
            }
            ++i;
        }
    }

    public Slot func_20127_a(IInventory iinventory, int i) {
        int j = 0;
        while (j < this.inventorySlots.size()) {
            Slot slot = (Slot)this.inventorySlots.get(j);
            if (slot.isHere(iinventory, i)) {
                return slot;
            }
            ++j;
        }
        return null;
    }

    public Slot getSlot(int i) {
        return (Slot)this.inventorySlots.get(i);
    }

    public ItemStack getStackInSlot(int i) {
        Slot slot = (Slot)this.inventorySlots.get(i);
        if (slot != null) {
            return slot.getStack();
        }
        return null;
    }

    public ItemStack func_27085_a(int i, int j, boolean flag, EntityPlayer entityplayer) {
        ItemStack itemstack = null;
        if (j == 0 || j == 1) {
            InventoryPlayer inventoryplayer = entityplayer.inventory;
            if (i == -999) {
                if (inventoryplayer.getItemStack() != null && i == -999) {
                    if (j == 0) {
                        entityplayer.dropPlayerItem(inventoryplayer.getItemStack());
                        inventoryplayer.setItemStack(null);
                    }
                    if (j == 1) {
                        entityplayer.dropPlayerItem(inventoryplayer.getItemStack().splitStack(1));
                        if (inventoryplayer.getItemStack().stackSize == 0) {
                            inventoryplayer.setItemStack(null);
                        }
                    }
                }
            } else if (flag) {
                ItemStack itemstack1 = this.getStackInSlot(i);
                if (itemstack1 != null) {
                    int l;
                    int k = itemstack1.stackSize;
                    itemstack = itemstack1.copy();
                    Slot slot1 = (Slot)this.inventorySlots.get(i);
                    if (slot1 != null && slot1.getStack() != null && (l = slot1.getStack().stackSize) < k) {
                        this.func_27085_a(i, j, flag, entityplayer);
                    }
                }
            } else {
                Slot slot = (Slot)this.inventorySlots.get(i);
                if (slot != null) {
                    int l1;
                    slot.onSlotChanged();
                    ItemStack itemstack2 = slot.getStack();
                    ItemStack itemstack3 = inventoryplayer.getItemStack();
                    if (itemstack2 != null) {
                        itemstack = itemstack2.copy();
                    }
                    if (itemstack2 == null) {
                        if (itemstack3 != null && slot.isItemValid(itemstack3)) {
                            int i1;
                            int n = i1 = j != 0 ? 1 : itemstack3.stackSize;
                            if (i1 > slot.getSlotStackLimit()) {
                                i1 = slot.getSlotStackLimit();
                            }
                            slot.putStack(itemstack3.splitStack(i1));
                            if (itemstack3.stackSize == 0) {
                                inventoryplayer.setItemStack(null);
                            }
                        }
                    } else if (itemstack3 == null) {
                        int j1 = j != 0 ? (itemstack2.stackSize + 1) / 2 : itemstack2.stackSize;
                        ItemStack itemstack5 = slot.decrStackSize(j1);
                        inventoryplayer.setItemStack(itemstack5);
                        if (itemstack2.stackSize == 0) {
                            slot.putStack(null);
                        }
                        slot.onPickupFromSlot(inventoryplayer.getItemStack());
                    } else if (slot.isItemValid(itemstack3)) {
                        if (itemstack2.itemID != itemstack3.itemID || itemstack2.getHasSubtypes() && itemstack2.getItemDamage() != itemstack3.getItemDamage()) {
                            if (itemstack3.stackSize <= slot.getSlotStackLimit()) {
                                ItemStack itemstack4 = itemstack2;
                                slot.putStack(itemstack3);
                                inventoryplayer.setItemStack(itemstack4);
                            }
                        } else {
                            int k1;
                            int n = k1 = j != 0 ? 1 : itemstack3.stackSize;
                            if (k1 > slot.getSlotStackLimit() - itemstack2.stackSize) {
                                k1 = slot.getSlotStackLimit() - itemstack2.stackSize;
                            }
                            if (k1 > itemstack3.getMaxStackSize() - itemstack2.stackSize) {
                                k1 = itemstack3.getMaxStackSize() - itemstack2.stackSize;
                            }
                            itemstack3.splitStack(k1);
                            if (itemstack3.stackSize == 0) {
                                inventoryplayer.setItemStack(null);
                            }
                            itemstack2.stackSize += k1;
                        }
                    } else if (!(itemstack2.itemID != itemstack3.itemID || itemstack3.getMaxStackSize() <= 1 || itemstack2.getHasSubtypes() && itemstack2.getItemDamage() != itemstack3.getItemDamage() || (l1 = itemstack2.stackSize) <= 0 || l1 + itemstack3.stackSize > itemstack3.getMaxStackSize())) {
                        itemstack3.stackSize += l1;
                        itemstack2.splitStack(l1);
                        if (itemstack2.stackSize == 0) {
                            slot.putStack(null);
                        }
                        slot.onPickupFromSlot(inventoryplayer.getItemStack());
                    }
                }
            }
        }
        return itemstack;
    }

    public void onCraftGuiClosed(EntityPlayer entityplayer) {
        InventoryPlayer inventoryplayer = entityplayer.inventory;
        if (inventoryplayer.getItemStack() != null) {
            entityplayer.dropPlayerItem(inventoryplayer.getItemStack());
            inventoryplayer.setItemStack(null);
        }
    }

    public void onCraftMatrixChanged(IInventory iinventory) {
        this.updateCraftingMatrix();
    }

    public boolean getCanCraft(EntityPlayer entityplayer) {
        return !this.field_20131_b.contains(entityplayer);
    }

    public void setCanCraft(EntityPlayer entityplayer, boolean flag) {
        if (flag) {
            this.field_20131_b.remove(entityplayer);
        } else {
            this.field_20131_b.add(entityplayer);
        }
    }

    public abstract boolean canInteractWith(EntityPlayer var1);

    protected void func_28126_a(ItemStack itemstack, int i, int j, boolean flag) {
        int k = i;
        if (flag) {
            k = j - 1;
        }
        if (itemstack.isStackable()) {
            while (itemstack.stackSize > 0 && (!flag && k < j || flag && k >= i)) {
                Slot slot = (Slot)this.inventorySlots.get(k);
                ItemStack itemstack1 = slot.getStack();
                if (!(itemstack1 == null || itemstack1.itemID != itemstack.itemID || itemstack.getHasSubtypes() && itemstack.getItemDamage() != itemstack1.getItemDamage())) {
                    int i1 = itemstack1.stackSize + itemstack.stackSize;
                    if (i1 <= itemstack.getMaxStackSize()) {
                        itemstack.stackSize = 0;
                        itemstack1.stackSize = i1;
                        slot.onSlotChanged();
                    } else if (itemstack1.stackSize < itemstack.getMaxStackSize()) {
                        itemstack.stackSize -= itemstack.getMaxStackSize() - itemstack1.stackSize;
                        itemstack1.stackSize = itemstack.getMaxStackSize();
                        slot.onSlotChanged();
                    }
                }
                if (flag) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        if (itemstack.stackSize > 0) {
            int l = flag ? j - 1 : i;
            while (!flag && l < j || flag && l >= i) {
                Slot slot1 = (Slot)this.inventorySlots.get(l);
                ItemStack itemstack2 = slot1.getStack();
                if (itemstack2 == null) {
                    slot1.putStack(itemstack.copy());
                    slot1.onSlotChanged();
                    itemstack.stackSize = 0;
                    break;
                }
                if (flag) {
                    --l;
                    continue;
                }
                ++l;
            }
        }
    }
}

