/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.player.inventory;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.ICrafting;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntityFurnace;
import com.mojang.minecraft.player.inventory.Container;
import com.mojang.minecraft.player.inventory.InventoryPlayer;
import com.mojang.minecraft.player.inventory.Slot;
import com.mojang.minecraft.player.inventory.SlotFurnace;

public class ContainerFurnace
extends Container {
    private TileEntityFurnace furnace;
    private int lastCookTime = 0;
    private int lastBurnTime = 0;
    private int lastItemBurnTime = 0;

    public ContainerFurnace(InventoryPlayer inventoryplayer, TileEntityFurnace tileentityfurnace) {
        this.furnace = tileentityfurnace;
        this.addSlot(new Slot(tileentityfurnace, 0, 56, 17));
        this.addSlot(new Slot(tileentityfurnace, 1, 56, 53));
        this.addSlot(new SlotFurnace(inventoryplayer.player, tileentityfurnace, 2, 116, 35));
        int i = 0;
        while (i < 3) {
            int k = 0;
            while (k < 9) {
                this.addSlot(new Slot(inventoryplayer, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
                ++k;
            }
            ++i;
        }
        int j = 0;
        while (j < 9) {
            this.addSlot(new Slot(inventoryplayer, j, 8 + j * 18, 142));
            ++j;
        }
    }

    public void onCraftGuiOpened(ICrafting icrafting) {
        super.onCraftGuiOpened(icrafting);
        icrafting.updateCraftingInventoryInfo(this, 0, this.furnace.furnaceCookTime);
        icrafting.updateCraftingInventoryInfo(this, 1, this.furnace.furnaceBurnTime);
        icrafting.updateCraftingInventoryInfo(this, 2, this.furnace.currentItemBurnTime);
    }

    public void updateCraftingMatrix() {
        super.updateCraftingMatrix();
        int i = 0;
        while (i < this.crafters.size()) {
            ICrafting icrafting = (ICrafting)this.crafters.get(i);
            if (this.lastCookTime != this.furnace.furnaceCookTime) {
                icrafting.updateCraftingInventoryInfo(this, 0, this.furnace.furnaceCookTime);
            }
            if (this.lastBurnTime != this.furnace.furnaceBurnTime) {
                icrafting.updateCraftingInventoryInfo(this, 1, this.furnace.furnaceBurnTime);
            }
            if (this.lastItemBurnTime != this.furnace.currentItemBurnTime) {
                icrafting.updateCraftingInventoryInfo(this, 2, this.furnace.currentItemBurnTime);
            }
            ++i;
        }
        this.lastCookTime = this.furnace.furnaceCookTime;
        this.lastBurnTime = this.furnace.furnaceBurnTime;
        this.lastItemBurnTime = this.furnace.currentItemBurnTime;
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return this.furnace.canInteractWith(entityplayer);
    }

    public ItemStack getStackInSlot(int i) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.inventorySlots.get(i);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if (i == 2) {
                this.func_28126_a(itemstack1, 3, 39, true);
            } else if (i >= 3 && i < 30) {
                this.func_28126_a(itemstack1, 30, 39, false);
            } else if (i >= 30 && i < 39) {
                this.func_28126_a(itemstack1, 3, 30, false);
            } else {
                this.func_28126_a(itemstack1, 3, 39, false);
            }
            if (itemstack1.stackSize == 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
            if (itemstack1.stackSize != itemstack.stackSize) {
                slot.onPickupFromSlot(itemstack1);
            } else {
                return null;
            }
        }
        return itemstack;
    }
}

