/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.player.inventory;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemArmor;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.nbt.NBTTagList;

public class InventoryPlayer
implements IInventory {
    public ItemStack[] mainInventory = new ItemStack[37];
    public ItemStack[] armorInventory = new ItemStack[4];
    public ItemStack[] craftingInventory = new ItemStack[4];
    public int currentItem = 0;
    public EntityPlayer player;
    private ItemStack itemStack;
    public boolean inventoryChanged = false;

    public InventoryPlayer(EntityPlayer entityplayer) {
        this.player = entityplayer;
    }

    public ItemStack getCurrentItem() {
        if (this.currentItem < 9 && this.currentItem >= 0) {
            return this.mainInventory[this.currentItem];
        }
        return null;
    }

    public static int func_25054_e() {
        return 9;
    }

    private int getInventorySlotContainItem(int i) {
        int j = 0;
        while (j < this.mainInventory.length) {
            if (this.mainInventory[j] != null && this.mainInventory[j].itemID == i) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    private int storeItemStack(ItemStack itemstack) {
        int i = 0;
        while (i < this.mainInventory.length) {
            if (this.mainInventory[i] != null && this.mainInventory[i].itemID == itemstack.itemID && this.mainInventory[i].isStackable() && this.mainInventory[i].stackSize < this.mainInventory[i].getMaxStackSize() && this.mainInventory[i].stackSize < this.getInventoryStackLimit() && (!this.mainInventory[i].getHasSubtypes() || this.mainInventory[i].getItemDamage() == itemstack.getItemDamage())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getFirstEmptyStack() {
        int i = 0;
        while (i < this.mainInventory.length) {
            if (this.mainInventory[i] == null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int setCurrentItem(ItemStack itemstack) {
        int l;
        int i = itemstack.itemID;
        int j = itemstack.stackSize;
        int k = this.storeItemStack(itemstack);
        if (k < 0) {
            k = this.getFirstEmptyStack();
        }
        if (k < 0) {
            return j;
        }
        if (this.mainInventory[k] == null) {
            this.mainInventory[k] = new ItemStack(i, 0, itemstack.getItemDamage());
        }
        if ((l = j) > this.mainInventory[k].getMaxStackSize() - this.mainInventory[k].stackSize) {
            l = this.mainInventory[k].getMaxStackSize() - this.mainInventory[k].stackSize;
        }
        if (l > this.getInventoryStackLimit() - this.mainInventory[k].stackSize) {
            l = this.getInventoryStackLimit() - this.mainInventory[k].stackSize;
        }
        if (l == 0) {
            return j;
        }
        this.mainInventory[k].stackSize += l;
        this.mainInventory[k].animationsToGo = 5;
        return j -= l;
    }

    public void decrementAnimations() {
        int i = 0;
        while (i < this.mainInventory.length) {
            if (this.mainInventory[i] != null) {
                this.mainInventory[i].func_28143_a(this.player.worldObj, this.player, i, this.currentItem == i);
            }
            ++i;
        }
    }

    public boolean consumeInventoryItem(int i) {
        int j = this.getInventorySlotContainItem(i);
        if (j < 0) {
            return false;
        }
        if (--this.mainInventory[j].stackSize <= 0) {
            this.mainInventory[j] = null;
        }
        return true;
    }

    public boolean addItemStackToInventory(ItemStack itemstack) {
        if (!itemstack.isItemDamaged()) {
            int i;
            do {
                i = itemstack.stackSize;
                itemstack.stackSize = this.setCurrentItem(itemstack);
            } while (itemstack.stackSize > 0 && itemstack.stackSize < i);
            return itemstack.stackSize < i;
        }
        int j = this.getFirstEmptyStack();
        if (j >= 0) {
            this.mainInventory[j] = ItemStack.func_20117_a(itemstack);
            this.mainInventory[j].animationsToGo = 5;
            itemstack.stackSize = 0;
            return true;
        }
        return false;
    }

    public ItemStack decrStackSize(int i, int j) {
        ItemStack[] aitemstack = this.mainInventory;
        if (i >= this.mainInventory.length) {
            aitemstack = this.armorInventory;
            i -= this.mainInventory.length;
        }
        if (aitemstack[i] != null) {
            if (aitemstack[i].stackSize <= j) {
                ItemStack itemstack = aitemstack[i];
                aitemstack[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = aitemstack[i].splitStack(j);
            if (aitemstack[i].stackSize == 0) {
                aitemstack[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public int getSpongeCount() {
        int count = 0;
        if (this.armorInventory[0] != null && this.armorInventory[0].itemID == 374) {
            ++count;
        }
        if (this.armorInventory[1] != null && this.armorInventory[1].itemID == 373) {
            ++count;
        }
        if (this.armorInventory[2] != null && this.armorInventory[2].itemID == 372) {
            ++count;
        }
        if (this.armorInventory[3] != null && this.armorInventory[3].itemID == 371) {
            ++count;
        }
        return count;
    }

    public int getArmorCount(String type) {
        int baseID = 0;
        if (type.equalsIgnoreCase("leather")) {
            baseID = Item.helmetLeather.shiftedIndex;
        }
        if (type.equalsIgnoreCase("gold")) {
            baseID = Item.helmetGold.shiftedIndex;
        }
        if (type.equalsIgnoreCase("chain") || type.equalsIgnoreCase("chainmail")) {
            baseID = Item.helmetChain.shiftedIndex;
        }
        if (type.equalsIgnoreCase("steel") || type.equalsIgnoreCase("iron")) {
            baseID = Item.helmetSteel.shiftedIndex;
        }
        if (type.equalsIgnoreCase("diamond") || type.equalsIgnoreCase("emerald")) {
            baseID = Item.helmetDiamond.shiftedIndex;
        }
        if (type.equalsIgnoreCase("sponge")) {
            baseID = Item.helmetSponge.shiftedIndex;
        }
        int count = 0;
        if (this.armorInventory[0] != null && this.armorInventory[0].itemID == baseID + 3) {
            ++count;
        }
        if (this.armorInventory[1] != null && this.armorInventory[1].itemID == baseID + 2) {
            ++count;
        }
        if (this.armorInventory[2] != null && this.armorInventory[2].itemID == baseID + 1) {
            ++count;
        }
        if (this.armorInventory[3] != null && this.armorInventory[3].itemID == baseID) {
            ++count;
        }
        return count;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        ItemStack[] aitemstack = this.mainInventory;
        if (i >= aitemstack.length) {
            i -= aitemstack.length;
            aitemstack = this.armorInventory;
            if (i >= 4) {
                i -= 4;
                aitemstack = this.craftingInventory;
            }
        }
        aitemstack[i] = itemstack;
    }

    public float getStrVsBlock(Block block) {
        float f = 1.0f;
        if (this.mainInventory[this.currentItem] != null) {
            f *= this.mainInventory[this.currentItem].getStrVsBlock(block);
        }
        return f;
    }

    public NBTTagList writeToNBT(NBTTagList nbttaglist) {
        NBTTagCompound nbttagcompound1;
        int i = 0;
        while (i < this.mainInventory.length) {
            if (this.mainInventory[i] != null) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.setByte("Slot", (byte)i);
                this.mainInventory[i].writeToNBT(nbttagcompound);
                nbttaglist.setTag(nbttagcompound);
            }
            ++i;
        }
        int j = 0;
        while (j < this.armorInventory.length) {
            if (this.armorInventory[j] != null) {
                nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.setByte("Slot", (byte)(j + 100));
                this.armorInventory[j].writeToNBT(nbttagcompound1);
                nbttaglist.setTag(nbttagcompound1);
            }
            ++j;
        }
        j = 0;
        while (j < this.craftingInventory.length) {
            if (this.craftingInventory[j] != null) {
                nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.setByte("Slot", (byte)(j + 80));
                this.craftingInventory[j].writeToNBT(nbttagcompound1);
                nbttaglist.setTag(nbttagcompound1);
            }
            ++j;
        }
        return nbttaglist;
    }

    public void readFromNBT(NBTTagList nbttaglist) {
        this.mainInventory = new ItemStack[36];
        this.armorInventory = new ItemStack[4];
        this.craftingInventory = new ItemStack[4];
        int i = 0;
        while (i < nbttaglist.tagCount()) {
            NBTTagCompound nbttagcompound = (NBTTagCompound)nbttaglist.tagAt(i);
            int j = nbttagcompound.getByte("Slot") & 0xFF;
            ItemStack itemstack = new ItemStack(nbttagcompound);
            if (itemstack.getItem() != null) {
                if (j >= 0 && j < this.mainInventory.length) {
                    this.mainInventory[j] = itemstack;
                }
                if (j >= 80 && j < this.craftingInventory.length + 80) {
                    this.craftingInventory[j - 80] = itemstack;
                }
                if (j >= 100 && j < this.armorInventory.length + 100) {
                    this.armorInventory[j - 100] = itemstack;
                }
            }
            ++i;
        }
    }

    public int getSizeInventory() {
        return this.mainInventory.length + 4;
    }

    public ItemStack getStackInSlot(int i) {
        ItemStack[] aitemstack = this.mainInventory;
        if (i >= aitemstack.length) {
            i -= aitemstack.length;
            aitemstack = this.armorInventory;
        }
        if (i >= aitemstack.length) {
            i -= aitemstack.length;
            aitemstack = this.craftingInventory;
        }
        return aitemstack[i];
    }

    public String getInvName() {
        return "Inventory";
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public int getDamageVsEntity(Entity entity) {
        ItemStack itemstack = this.getStackInSlot(this.currentItem);
        if (itemstack != null) {
            return itemstack.getDamageVsEntity(entity);
        }
        return 1;
    }

    public boolean canHarvestBlock(Block block) {
        if (block.blockMaterial.func_31055_i()) {
            return true;
        }
        ItemStack itemstack = this.getStackInSlot(this.currentItem);
        if (itemstack != null) {
            return itemstack.canHarvestBlock(block);
        }
        return false;
    }

    public boolean canHarvestBlockGoldTouch(Block canBreakWithHands) {
        ItemStack itemstack = this.getStackInSlot(this.currentItem);
        if (itemstack != null) {
            return itemstack.isGold();
        }
        return false;
    }

    public int getTotalArmorValue() {
        int armorNewDmg = 0;
        int armorDmg = 0;
        int armorMaxDmg = 0;
        int l = 0;
        while (l < this.armorInventory.length) {
            if (this.armorInventory[l] != null && this.armorInventory[l].getItem() instanceof ItemArmor) {
                int maxDmg = this.armorInventory[l].getMaxDamage();
                int currDmg = this.armorInventory[l].getItemDamageForDisplay();
                int newDmg = maxDmg - currDmg;
                armorDmg += newDmg;
                armorMaxDmg += maxDmg;
                int protLevel = ((ItemArmor)this.armorInventory[l].getItem()).protectionLevel;
                armorNewDmg += protLevel;
            }
            ++l;
        }
        if (armorMaxDmg == 0) {
            return 0;
        }
        return armorNewDmg;
    }

    public void damageArmor(int i) {
        int j = 0;
        while (j < this.armorInventory.length) {
            if (this.armorInventory[j] != null && this.armorInventory[j].getItem() instanceof ItemArmor) {
                this.armorInventory[j].damageItem(i, this.player);
                if (this.armorInventory[j].stackSize == 0) {
                    this.armorInventory[j].func_577_a(this.player);
                    this.armorInventory[j] = null;
                }
            }
            ++j;
        }
    }

    public void dropAllItems() {
        int i = 0;
        while (i < this.mainInventory.length) {
            if (this.mainInventory[i] != null) {
                this.player.dropPlayerItemWithRandomChoice(this.mainInventory[i], true);
                this.mainInventory[i] = null;
            }
            ++i;
        }
        int j = 0;
        while (j < this.armorInventory.length) {
            if (this.armorInventory[j] != null) {
                this.player.dropPlayerItemWithRandomChoice(this.armorInventory[j], true);
                this.armorInventory[j] = null;
            }
            ++j;
        }
        j = 0;
        while (j < this.craftingInventory.length) {
            if (this.craftingInventory[j] != null) {
                this.player.dropPlayerItemWithRandomChoice(this.craftingInventory[j], true);
                this.craftingInventory[j] = null;
            }
            ++j;
        }
    }

    public void onInventoryChanged() {
        this.inventoryChanged = true;
    }

    public void setItemStack(ItemStack itemstack) {
        this.itemStack = itemstack;
        this.player.onItemStackChanged(itemstack);
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        if (this.player.isDead) {
            return false;
        }
        return entityplayer.getDistanceSqToEntity(this.player) <= 64.0;
    }

    public boolean func_28010_c(ItemStack itemstack) {
        int i = 0;
        while (i < this.armorInventory.length) {
            if (this.armorInventory[i] != null && this.armorInventory[i].func_28144_c(itemstack)) {
                return true;
            }
            ++i;
        }
        int j = 0;
        while (j < this.mainInventory.length) {
            if (this.mainInventory[j] != null && this.mainInventory[j].func_28144_c(itemstack)) {
                return true;
            }
            ++j;
        }
        j = 0;
        while (j < this.craftingInventory.length) {
            if (this.craftingInventory[j] != null && this.craftingInventory[j].func_28144_c(itemstack)) {
                return true;
            }
            ++j;
        }
        return false;
    }
}

