/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.server;

import com.mojang.minecraft.entity.EntityChicken;
import com.mojang.minecraft.entity.EntityCow;
import com.mojang.minecraft.entity.EntityCreeper;
import com.mojang.minecraft.entity.EntityPig;
import com.mojang.minecraft.entity.EntitySheep;
import com.mojang.minecraft.entity.EntitySkeleton;
import com.mojang.minecraft.entity.EntitySlime;
import com.mojang.minecraft.entity.EntitySpider;
import com.mojang.minecraft.entity.EntityZombie;
import com.mojang.minecraft.enums.EnumCreatureType;
import com.mojang.minecraft.level.generate.WorldGenBigTree;
import com.mojang.minecraft.level.generate.WorldGenTrees;
import com.mojang.minecraft.level.generate.WorldGenerator;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.server.BiomeGenDesert;
import com.mojang.minecraft.server.BiomeGenForest;
import com.mojang.minecraft.server.BiomeGenHell;
import com.mojang.minecraft.server.BiomeGenRainforest;
import com.mojang.minecraft.server.BiomeGenSky;
import com.mojang.minecraft.server.BiomeGenSwamp;
import com.mojang.minecraft.server.BiomeGenTaiga;
import com.mojang.minecraft.server.SpawnListEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class BiomeGenBase {
    public static final BiomeGenBase rainforest = new BiomeGenRainforest().setColor(588342).setBiomeName("Rainforest").func_4080_a(2094168);
    public static final BiomeGenBase swampland = new BiomeGenSwamp().setColor(522674).setBiomeName("Swampland").func_4080_a(9154376);
    public static final BiomeGenBase seasonalForest = new BiomeGenBase().setColor(10215459).setBiomeName("Seasonal Forest");
    public static final BiomeGenBase forest = new BiomeGenForest().setColor(353825).setBiomeName("Forest").func_4080_a(5159473);
    public static final BiomeGenBase savanna = new BiomeGenDesert().setColor(14278691).setBiomeName("Savanna");
    public static final BiomeGenBase shrubland = new BiomeGenBase().setColor(10595616).setBiomeName("Shrubland");
    public static final BiomeGenBase taiga = new BiomeGenTaiga().setColor(3060051).setBiomeName("Taiga").setEnableSnow().func_4080_a(8107825);
    public static final BiomeGenBase desert = new BiomeGenDesert().setColor(16421912).setBiomeName("Desert").setDisableRain();
    public static final BiomeGenBase plains = new BiomeGenDesert().setColor(16767248).setBiomeName("Plains");
    public static final BiomeGenBase iceDesert = new BiomeGenDesert().setColor(16772499).setBiomeName("Ice Desert").setEnableSnow().setDisableRain().func_4080_a(12899129);
    public static final BiomeGenBase tundra = new BiomeGenBase().setColor(5762041).setBiomeName("Tundra").setEnableSnow().func_4080_a(12899129);
    public static final BiomeGenBase hell = new BiomeGenHell().setColor(0xFF0000).setBiomeName("Hell").setDisableRain();
    public static final BiomeGenBase field_28054_m = new BiomeGenSky().setColor(0x8080FF).setBiomeName("Sky").setDisableRain();
    public String biomeName;
    public int color;
    public byte topBlock;
    public byte fillerBlock;
    public int field_6161_q;
    protected List spawnableMonsterList;
    protected List spawnableCreatureList;
    protected List spawnableWaterCreatureList;
    private boolean enableSnow;
    private boolean enableRain;
    private static BiomeGenBase[] biomeLookupTable = new BiomeGenBase[4096];

    static {
        BiomeGenBase.generateBiomeLookup();
    }

    protected BiomeGenBase() {
        this.topBlock = (byte)Block.grass.blockID;
        this.fillerBlock = (byte)Block.dirt.blockID;
        this.field_6161_q = 5169201;
        this.spawnableMonsterList = new ArrayList();
        this.spawnableCreatureList = new ArrayList();
        this.spawnableWaterCreatureList = new ArrayList();
        this.enableRain = true;
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySpider.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityZombie.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySkeleton.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityCreeper.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySlime.class, 10));
        this.spawnableCreatureList.add(new SpawnListEntry(EntitySheep.class, 12));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityPig.class, 10));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityChicken.class, 10));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityCow.class, 8));
    }

    private BiomeGenBase setDisableRain() {
        this.enableRain = false;
        return this;
    }

    public static void generateBiomeLookup() {
        int i = 0;
        while (i < 64) {
            int j = 0;
            while (j < 64) {
                BiomeGenBase.biomeLookupTable[i + j * 64] = BiomeGenBase.getBiome((float)i / 63.0f, (float)j / 63.0f);
                ++j;
            }
            ++i;
        }
        BiomeGenBase.desert.topBlock = BiomeGenBase.desert.fillerBlock = (byte)Block.sand.blockID;
        BiomeGenBase.iceDesert.topBlock = BiomeGenBase.iceDesert.fillerBlock = (byte)Block.sand.blockID;
    }

    public WorldGenerator getRandomWorldGenForTrees(Random random) {
        if (random.nextInt(10) == 0) {
            return new WorldGenBigTree();
        }
        return new WorldGenTrees();
    }

    protected BiomeGenBase setEnableSnow() {
        this.enableSnow = true;
        return this;
    }

    protected BiomeGenBase setBiomeName(String s) {
        this.biomeName = s;
        return this;
    }

    protected BiomeGenBase func_4080_a(int i) {
        this.field_6161_q = i;
        return this;
    }

    protected BiomeGenBase setColor(int i) {
        this.color = i;
        return this;
    }

    public static BiomeGenBase getBiomeFromLookup(double d, double d1) {
        int i = (int)(d * 63.0);
        int j = (int)(d1 * 63.0);
        return biomeLookupTable[i + j * 64];
    }

    public static BiomeGenBase getBiome(float f, float f1) {
        f1 *= f;
        if (f < 0.1f) {
            return tundra;
        }
        if (f1 < 0.2f) {
            if (f < 0.5f) {
                return tundra;
            }
            if (f < 0.95f) {
                return savanna;
            }
            return desert;
        }
        if (f1 > 0.5f && f < 0.7f) {
            return swampland;
        }
        if (f < 0.5f) {
            return taiga;
        }
        if (f < 0.97f) {
            if (f1 < 0.35f) {
                return shrubland;
            }
            return forest;
        }
        if (f1 < 0.45f) {
            return plains;
        }
        if (f1 < 0.9f) {
            return seasonalForest;
        }
        return rainforest;
    }

    public List getSpawnableList(EnumCreatureType enumcreaturetype) {
        if (enumcreaturetype == EnumCreatureType.monster) {
            return this.spawnableMonsterList;
        }
        if (enumcreaturetype == EnumCreatureType.creature) {
            return this.spawnableCreatureList;
        }
        if (enumcreaturetype == EnumCreatureType.waterCreature) {
            return this.spawnableWaterCreatureList;
        }
        return null;
    }

    public boolean getEnableSnow() {
        return this.enableSnow;
    }

    public boolean canSpawnLightningBolt() {
        if (this.enableSnow) {
            return false;
        }
        return this.enableRain;
    }
}

