/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.server;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.server.MapCoord;
import com.mojang.minecraft.server.MapDataBase;
import com.mojang.minecraft.server.MapInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapData
extends MapDataBase {
    public int field_28164_b;
    public int field_28163_c;
    public byte field_28162_d;
    public byte field_28161_e;
    public byte[] field_28160_f = new byte[16384];
    public int field_28159_g;
    public List field_28158_h = new ArrayList();
    private Map field_28156_j = new HashMap();
    public List field_28157_i = new ArrayList();

    public MapData(String s) {
        super(s);
    }

    public void func_28148_a(NBTTagCompound nbttagcompound) {
        this.field_28162_d = nbttagcompound.getByte("dimension");
        this.field_28164_b = nbttagcompound.getInteger("xCenter");
        this.field_28163_c = nbttagcompound.getInteger("zCenter");
        this.field_28161_e = nbttagcompound.getByte("scale");
        if (this.field_28161_e < 0) {
            this.field_28161_e = 0;
        }
        if (this.field_28161_e > 4) {
            this.field_28161_e = (byte)4;
        }
        int word0 = nbttagcompound.getShort("width");
        int word1 = nbttagcompound.getShort("height");
        if (word0 == 128 && word1 == 128) {
            this.field_28160_f = nbttagcompound.getByteArray("colors");
        } else {
            byte[] abyte0 = nbttagcompound.getByteArray("colors");
            this.field_28160_f = new byte[16384];
            int i = (128 - word0) / 2;
            int j = (128 - word1) / 2;
            int k = 0;
            while (k < word1) {
                int l = k + j;
                if (l >= 0 || l < 128) {
                    int i1 = 0;
                    while (i1 < word0) {
                        int j1 = i1 + i;
                        if (j1 >= 0 || j1 < 128) {
                            this.field_28160_f[j1 + l * 128] = abyte0[i1 + k * word0];
                        }
                        ++i1;
                    }
                }
                ++k;
            }
        }
    }

    public void func_28147_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.setByte("dimension", this.field_28162_d);
        nbttagcompound.setInteger("xCenter", this.field_28164_b);
        nbttagcompound.setInteger("zCenter", this.field_28163_c);
        nbttagcompound.setByte("scale", this.field_28161_e);
        nbttagcompound.setShort("width", (short)128);
        nbttagcompound.setShort("height", (short)128);
        nbttagcompound.setByteArray("colors", this.field_28160_f);
    }

    public void func_28155_a(EntityPlayer entityplayer, ItemStack itemstack) {
        if (!this.field_28156_j.containsKey(entityplayer)) {
            MapInfo mapinfo = new MapInfo(this, entityplayer);
            this.field_28156_j.put(entityplayer, mapinfo);
            this.field_28158_h.add(mapinfo);
        }
        this.field_28157_i.clear();
        int i = 0;
        while (i < this.field_28158_h.size()) {
            MapInfo mapinfo1 = (MapInfo)this.field_28158_h.get(i);
            if (mapinfo1.field_28120_a.isDead || !mapinfo1.field_28120_a.inventory.func_28010_c(itemstack)) {
                this.field_28156_j.remove(mapinfo1.field_28120_a);
                this.field_28158_h.remove(mapinfo1);
            } else {
                float f = (float)(mapinfo1.field_28120_a.posX - (double)this.field_28164_b) / (float)(1 << this.field_28161_e);
                float f1 = (float)(mapinfo1.field_28120_a.posZ - (double)this.field_28163_c) / (float)(1 << this.field_28161_e);
                int j = 64;
                int k = 64;
                if (!(f < (float)(-j) || f1 < (float)(-k) || f > (float)j || f1 > (float)k)) {
                    byte byte0 = 0;
                    byte byte1 = (byte)((double)(f * 2.0f) + 0.5);
                    byte byte2 = (byte)((double)(f1 * 2.0f) + 0.5);
                    byte byte3 = (byte)((double)(entityplayer.rotationYaw * 16.0f / 360.0f) + 0.5);
                    if (this.field_28162_d < 0) {
                        int l = this.field_28159_g / 10;
                        byte3 = (byte)(l * l * 34187121 + l * 121 >> 15 & 0xF);
                    }
                    if (mapinfo1.field_28120_a.dimension == this.field_28162_d) {
                        this.field_28157_i.add(new MapCoord(this, byte0, byte1, byte2, byte3));
                    }
                }
            }
            ++i;
        }
    }

    public byte[] func_28154_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        MapInfo mapinfo = (MapInfo)this.field_28156_j.get(entityplayer);
        if (mapinfo == null) {
            return null;
        }
        byte[] abyte0 = mapinfo.func_28118_a(itemstack);
        return abyte0;
    }

    public void func_28153_a(int i, int j, int k) {
        super.func_28146_a();
        int l = 0;
        while (l < this.field_28158_h.size()) {
            MapInfo mapinfo = (MapInfo)this.field_28158_h.get(l);
            if (mapinfo.field_28119_b[i] < 0 || mapinfo.field_28119_b[i] > j) {
                mapinfo.field_28119_b[i] = j;
            }
            if (mapinfo.field_28125_c[i] < 0 || mapinfo.field_28125_c[i] < k) {
                mapinfo.field_28125_c[i] = k;
            }
            ++l;
        }
    }
}

