/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.server;

import com.mojang.minecraft.entity.EntityTracker;
import com.mojang.minecraft.gui.ConsoleCommandHandler;
import com.mojang.minecraft.gui.ConsoleLogManager;
import com.mojang.minecraft.gui.ICommandListener;
import com.mojang.minecraft.level.chunk.ChunkCoordinates;
import com.mojang.minecraft.level.chunk.SaveConverterMcRegion;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.network.NetworkListenThread;
import com.mojang.minecraft.network.PlayerScore;
import com.mojang.minecraft.network.packet.Packet4UpdateTime;
import com.mojang.minecraft.network.packet.Packet69PlayerScore;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.server.ConvertProgressUpdater;
import com.mojang.minecraft.server.ISaveFormat;
import com.mojang.minecraft.server.IUpdatePlayerListBox;
import com.mojang.minecraft.server.PropertyManager;
import com.mojang.minecraft.server.SaveOldDir;
import com.mojang.minecraft.server.ServerCommand;
import com.mojang.minecraft.server.ServerConfigurationManager;
import com.mojang.minecraft.server.ServerGUI;
import com.mojang.minecraft.server.ThreadCommandReader;
import com.mojang.minecraft.server.ThreadServerApplication;
import com.mojang.minecraft.server.WorldManager;
import com.mojang.minecraft.server.WorldServer;
import com.mojang.minecraft.server.WorldServerMulti;
import com.mojang.minecraft.util.ThreadSleepForever;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MinecraftServer
implements Runnable,
ICommandListener {
    public static Logger logger = Logger.getLogger("Minecraft");
    public static HashMap field_6037_b = new HashMap();
    public NetworkListenThread networkServer;
    public PropertyManager propertyManagerObj;
    public WorldServer[] worldMngr;
    public ServerConfigurationManager configManager;
    private ConsoleCommandHandler commandHandler;
    private boolean serverRunning = true;
    public boolean serverStopped = false;
    int deathTime = 0;
    public String currentTask;
    public int percentDone;
    private List field_9010_p = new ArrayList();
    private List commands = Collections.synchronizedList(new ArrayList());
    public EntityTracker[] entityTracker = new EntityTracker[2];
    public boolean onlineMode;
    public boolean spawnPeacefulMobs;
    public boolean pvpOn;
    public boolean allowFlight;
    public ArrayList<PlayerScore> players;
    private static MinecraftServer theMinecraft;

    public MinecraftServer() {
        new ThreadSleepForever(this);
        this.players = new ArrayList();
        theMinecraft = this;
    }

    private boolean startServer() throws UnknownHostException {
        this.commandHandler = new ConsoleCommandHandler(this);
        ThreadCommandReader threadcommandreader = new ThreadCommandReader(this);
        threadcommandreader.setDaemon(true);
        threadcommandreader.start();
        ConsoleLogManager.init();
        logger.info("Starting NSSS server version Alpha 1.1.12");
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            logger.warning("**** NOT ENOUGH RAM!");
            logger.warning("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        logger.info("Loading properties");
        this.propertyManagerObj = new PropertyManager(new File("server.properties"));
        String s = this.propertyManagerObj.getStringProperty("server-ip", "");
        this.onlineMode = this.propertyManagerObj.getBooleanProperty("online-mode", true);
        this.spawnPeacefulMobs = this.propertyManagerObj.getBooleanProperty("spawn-animals", true);
        this.pvpOn = this.propertyManagerObj.getBooleanProperty("pvp", true);
        this.allowFlight = this.propertyManagerObj.getBooleanProperty("allow-flight", false);
        InetAddress inetaddress = null;
        if (s.length() > 0) {
            inetaddress = InetAddress.getByName(s);
        }
        int i = this.propertyManagerObj.getIntProperty("server-port", 25565);
        logger.info("Starting Minecraft server on " + (s.length() != 0 ? s : "*") + ":" + i);
        try {
            this.networkServer = new NetworkListenThread(this, inetaddress, i);
        }
        catch (IOException ioexception) {
            logger.warning("**** FAILED TO BIND TO PORT!");
            logger.log(Level.WARNING, "The exception was: " + ioexception.toString());
            logger.warning("Perhaps a server is already running on that port?");
            return false;
        }
        if (!this.onlineMode) {
            logger.warning("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            logger.warning("The server will make no attempt to authenticate usernames. Beware.");
            logger.warning("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            logger.warning("To change this, set \"online-mode\" to \"true\" in the server.settings file.");
        }
        this.configManager = new ServerConfigurationManager(this);
        this.entityTracker[0] = new EntityTracker(this, 0);
        this.entityTracker[1] = new EntityTracker(this, -1);
        long l = System.nanoTime();
        String levelname = this.propertyManagerObj.getStringProperty("level-name", "world");
        String levelSeed = this.propertyManagerObj.getStringProperty("level-seed", "");
        String levelType = this.propertyManagerObj.getStringProperty("world-type", "normal");
        String levelSeason = this.propertyManagerObj.getStringProperty("season", "summer");
        String levelWeather = this.propertyManagerObj.getStringProperty("weather", "seasonal");
        long l1 = new Random().nextLong();
        if (levelSeed.length() > 0) {
            try {
                l1 = Long.parseLong(levelSeed);
            }
            catch (NumberFormatException numberformatexception) {
                l1 = levelSeed.hashCode();
            }
        }
        logger.info("Preparing level \"" + levelname + "\"");
        this.initWorld(new SaveConverterMcRegion(new File(".")), levelname, l1, levelType, levelSeason, levelWeather);
        logger.info("Done (" + (System.nanoTime() - l) + "ns)! For help, type \"help\" or \"?\"");
        return true;
    }

    private void initWorld(ISaveFormat isaveformat, String levelName, long levelSeed, String worldType, String levelSeason, String levelWeather) {
        if (isaveformat.isOldSaveType(levelName)) {
            logger.info("Converting map!");
            isaveformat.converMapToMCRegion(levelName, new ConvertProgressUpdater(this));
        }
        this.worldMngr = new WorldServer[1];
        SaveOldDir saveolddir = new SaveOldDir(new File("."), levelName, true);
        int i = 0;
        if (i < this.worldMngr.length) {
            this.worldMngr[i] = i == 0 ? new WorldServer(this, saveolddir, levelName, i != 0 ? -1 : 0, levelSeed, worldType, levelSeason, levelWeather) : new WorldServerMulti(this, saveolddir, levelName, i != 0 ? -1 : 0, levelSeed, this.worldMngr[0]);
            this.worldMngr[i].addWorldAccess(new WorldManager(this, this.worldMngr[i]));
            this.worldMngr[i].difficultySetting = this.propertyManagerObj.getIntProperty("difficulty", 2);
            this.worldMngr[i].setAllowedSpawnTypes(this.propertyManagerObj.getBooleanProperty("spawn-monsters", true), this.spawnPeacefulMobs);
            this.configManager.setPlayerManager(this.worldMngr);
        }
        int c = 196;
        long l1 = System.currentTimeMillis();
        int j = 0;
        while (j < this.worldMngr.length) {
            logger.info("Preparing start region for level " + j);
            if (j == 0 || this.propertyManagerObj.getBooleanProperty("allow-nether", false)) {
                WorldServer worldserver = this.worldMngr[j];
                ChunkCoordinates chunkcoordinates = worldserver.getSpawnPoint();
                for (int k = -c; k <= c && this.serverRunning; k += 16) {
                    int i1 = -c;
                    while (i1 <= c && this.serverRunning) {
                        long l2 = System.currentTimeMillis();
                        if (l2 < l1) {
                            l1 = l2;
                        }
                        if (l2 > l1 + 1000L) {
                            int j1 = (c * 2 + 1) * (c * 2 + 1);
                            int k1 = (k + c) * (c * 2 + 1) + (i1 + 1);
                            this.outputPercentRemaining("Preparing spawn area", k1 * 100 / j1);
                            l1 = l2;
                        }
                        worldserver.chunkProviderServer.loadChunk(chunkcoordinates.posX + k >> 4, chunkcoordinates.posZ + i1 >> 4);
                        while (worldserver.func_6156_d() && this.serverRunning) {
                        }
                        i1 += 16;
                    }
                }
            }
            ++j;
        }
        this.clearCurrentTask();
    }

    public void cleanSpawnChunks(Boolean isWinter) {
        int c = 196;
        long l1 = System.currentTimeMillis();
        int j = 0;
        while (j < this.worldMngr.length) {
            logger.info("Cleaning start region for level " + j);
            if (j == 0 || this.propertyManagerObj.getBooleanProperty("allow-nether", false)) {
                WorldServer worldserver = this.worldMngr[j];
                ChunkCoordinates chunkcoordinates = worldserver.getSpawnPoint();
                for (int k = -c; k <= c && this.serverRunning; k += 16) {
                    int i1 = -c;
                    while (i1 <= c && this.serverRunning) {
                        long l2 = System.currentTimeMillis();
                        if (l2 < l1) {
                            l1 = l2;
                        }
                        if (l2 > l1 + 1000L) {
                            int j1 = (c * 2 + 1) * (c * 2 + 1);
                            int k1 = (k + c) * (c * 2 + 1) + (i1 + 1);
                            this.outputPercentRemaining("Cleaning spawn area", k1 * 100 / j1);
                            l1 = l2;
                        }
                        worldserver.chunkProviderServer.setSnowy(chunkcoordinates.posX + k >> 4, chunkcoordinates.posZ + i1 >> 4, isWinter);
                        while (worldserver.func_6156_d() && this.serverRunning) {
                        }
                        i1 += 16;
                    }
                }
            }
            ++j;
        }
    }

    private void outputPercentRemaining(String s, int i) {
        this.currentTask = s;
        this.percentDone = i;
        logger.info(s + ": " + i + "%");
    }

    private void clearCurrentTask() {
        this.currentTask = null;
        this.percentDone = 0;
    }

    private void saveServerWorld() {
        logger.info("Saving chunks");
        int i = 0;
        while (i < this.worldMngr.length) {
            WorldServer worldserver = this.worldMngr[i];
            worldserver.saveWorld(true, null);
            worldserver.func_30006_w();
            ++i;
        }
    }

    private void stopServer() {
        logger.info("Stopping server");
        if (this.configManager != null) {
            this.configManager.savePlayerStates();
        }
        int i = 0;
        while (i < this.worldMngr.length) {
            WorldServer worldserver = this.worldMngr[i];
            if (worldserver != null) {
                this.saveServerWorld();
            }
            ++i;
        }
    }

    public void initiateShutdown() {
        this.serverRunning = false;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block27: {
            try {
                try {
                    if (!this.startServer()) ** GOTO lbl30
                    l = System.currentTimeMillis();
                    l1 = 0L;
                    while (this.serverRunning) {
                        l2 = System.currentTimeMillis();
                        l3 = l2 - l;
                        if (l3 > 2000L) {
                            MinecraftServer.logger.warning("Can't keep up! Did the system time change, or is the server overloaded?");
                            l3 = 2000L;
                        }
                        if (l3 < 0L) {
                            MinecraftServer.logger.warning("Time ran backwards! Did the system time change?");
                            l3 = 0L;
                        }
                        l1 += l3;
                        l = l2;
                        while (l1 > 50L) {
                            l1 -= 50L;
                            this.doTick();
                        }
                        Thread.sleep(1L);
                    }
                    break block27;
lbl-1000:
                    // 1 sources

                    {
                        this.commandLineParser();
                        try {
                            Thread.sleep(10L);
                            continue;
                        }
                        catch (InterruptedException interruptedexception) {
                            interruptedexception.printStackTrace();
                        }
lbl30:
                        // 3 sources

                        ** while (this.serverRunning)
                    }
lbl31:
                    // 1 sources

                    break block27;
                }
                catch (Throwable throwable1) {
                    throwable1.printStackTrace();
                    MinecraftServer.logger.log(Level.SEVERE, "Unexpected exception", throwable1);
                    ** while (this.serverRunning)
                }
lbl-1000:
                // 1 sources

                {
                    this.commandLineParser();
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedexception1) {
                        interruptedexception1.printStackTrace();
                    }
                    continue;
lbl43:
                    // 1 sources

                }
            }
            finally {
                block29: {
                    try {
                        try {
                            this.stopServer();
                            this.serverStopped = true;
                        }
                        catch (Throwable throwable2) {
                            throwable2.printStackTrace();
                            System.exit(0);
                            break block29;
                        }
                    }
                    catch (Throwable var11_13) {
                        System.exit(0);
                        throw var11_13;
                    }
                    System.exit(0);
                }
            }
        }
    }

    private void doTick() {
        ArrayList<String> arraylist = new ArrayList<String>();
        for (String s : field_6037_b.keySet()) {
            int i1 = (Integer)field_6037_b.get(s);
            if (i1 > 0) {
                field_6037_b.put(s, i1 - 1);
                continue;
            }
            arraylist.add(s);
        }
        int i = 0;
        while (i < arraylist.size()) {
            field_6037_b.remove(arraylist.get(i));
            ++i;
        }
        AxisAlignedBB.clearBoundingBoxPool();
        Vec3D.initialize();
        ++this.deathTime;
        int j = 0;
        while (j < this.worldMngr.length) {
            if (j == 0 || this.propertyManagerObj.getBooleanProperty("allow-nether", false)) {
                WorldServer worldserver = this.worldMngr[j];
                if (this.deathTime % 20 == 0) {
                    this.configManager.sendPacketToAllPlayersInDimension(new Packet4UpdateTime(worldserver.getWorldTime()), worldserver.worldProvider.worldType);
                }
                worldserver.tick();
                while (worldserver.func_6156_d()) {
                }
                worldserver.updateEntities();
            }
            ++j;
        }
        this.networkServer.handleNetworkListenThread();
        this.configManager.onTick();
        int k = 0;
        while (k < this.entityTracker.length) {
            this.entityTracker[k].updateTrackedEntities();
            ++k;
        }
        int l = 0;
        while (l < this.field_9010_p.size()) {
            ((IUpdatePlayerListBox)this.field_9010_p.get(l)).update();
            ++l;
        }
        try {
            this.commandLineParser();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Unexpected exception while parsing console command", exception);
        }
    }

    public void addCommand(String s, ICommandListener icommandlistener) {
        this.commands.add(new ServerCommand(s, icommandlistener));
    }

    public void commandLineParser() {
        while (this.commands.size() > 0) {
            ServerCommand servercommand = (ServerCommand)this.commands.remove(0);
            this.commandHandler.handleCommand(servercommand);
        }
    }

    public void func_6022_a(IUpdatePlayerListBox iupdateplayerlistbox) {
        this.field_9010_p.add(iupdateplayerlistbox);
    }

    public static void main(String[] args) {
        try {
            MinecraftServer minecraftserver = new MinecraftServer();
            if (!(GraphicsEnvironment.isHeadless() || args.length > 0 && args[0].equals("nogui"))) {
                ServerGUI.initGui(minecraftserver);
            }
            new ThreadServerApplication("Server thread", minecraftserver).start();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Failed to start the minecraft server", exception);
        }
    }

    public File getFile(String s) {
        return new File(s);
    }

    public void log(String s) {
        logger.info(s);
    }

    public void logWarning(String s) {
        logger.warning(s);
    }

    public String getUsername() {
        return "CONSOLE";
    }

    public WorldServer getWorldManager(int i) {
        if (i == -1) {
            return this.worldMngr[1];
        }
        return this.worldMngr[0];
    }

    public EntityTracker getEntityTracker(int i) {
        if (i == -1) {
            return this.entityTracker[1];
        }
        return this.entityTracker[0];
    }

    public static boolean isServerRunning(MinecraftServer minecraftserver) {
        return minecraftserver.serverRunning;
    }

    public void addToPlayerList(String name, int score) {
        this.players.add(new PlayerScore(name, score));
        this.configManager.sendPacketToAllPlayers(new Packet69PlayerScore(name, score, true));
    }

    public int getIndexInPlayerList(String name) {
        int i = 0;
        while (i < this.players.size()) {
            if (this.players.get((int)i).playerName == name) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void updatePlayerScore(String name, int score) {
        if (this.getIndexInPlayerList(name) != -1) {
            this.players.get(this.getIndexInPlayerList(name)).setScore(score);
            this.configManager.sendPacketToAllPlayers(new Packet69PlayerScore(name, score, true));
        }
    }

    public void removeFromPlayerList(String name) {
        if (this.getIndexInPlayerList(name) != -1) {
            this.players.remove(this.getIndexInPlayerList(name));
            this.configManager.sendPacketToAllPlayers(new Packet69PlayerScore(name, 0, false));
        }
    }

    public static MinecraftServer getMinecraft() {
        return theMinecraft;
    }
}

