/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.server;

import com.mojang.minecraft.entity.EntityPlayerMP;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.level.chunk.ChunkCoordIntPair;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.network.packet.Packet;
import com.mojang.minecraft.network.packet.Packet50PreChunk;
import com.mojang.minecraft.network.packet.Packet51MapChunk;
import com.mojang.minecraft.network.packet.Packet52MultiBlockChange;
import com.mojang.minecraft.network.packet.Packet53BlockChange;
import com.mojang.minecraft.server.PlayerManager;
import com.mojang.minecraft.server.WorldServer;
import java.util.ArrayList;
import java.util.List;

class PlayerInstance {
    private List players;
    private int chunkX;
    private int chunkZ;
    private ChunkCoordIntPair currentChunk;
    private short[] blocksToUpdate;
    private int numBlocksToUpdate;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int minZ;
    private int maxZ;
    final PlayerManager playerManager;

    public PlayerInstance(PlayerManager playermanager, int i, int j) {
        this.playerManager = playermanager;
        this.players = new ArrayList();
        this.blocksToUpdate = new short[10];
        this.numBlocksToUpdate = 0;
        this.chunkX = i;
        this.chunkZ = j;
        this.currentChunk = new ChunkCoordIntPair(i, j);
        playermanager.getMinecraftServer().chunkProviderServer.loadChunk(i, j);
    }

    public void addPlayer(EntityPlayerMP entityplayermp) {
        if (this.players.contains(entityplayermp)) {
            throw new IllegalStateException("Failed to add player. " + entityplayermp + " already is in chunk " + this.chunkX + ", " + this.chunkZ);
        }
        entityplayermp.field_420_ah.add(this.currentChunk);
        entityplayermp.playerNetServerHandler.sendPacket(new Packet50PreChunk(this.currentChunk.chunkXPos, this.currentChunk.chunkZPos, true));
        this.players.add(entityplayermp);
        entityplayermp.loadedChunks.add(this.currentChunk);
    }

    public void removePlayer(EntityPlayerMP entityplayermp) {
        if (!this.players.contains(entityplayermp)) {
            return;
        }
        this.players.remove(entityplayermp);
        if (this.players.size() == 0) {
            long l = (long)this.chunkX + Integer.MAX_VALUE | (long)this.chunkZ + Integer.MAX_VALUE << 32;
            PlayerManager.getPlayerInstances(this.playerManager).remove(l);
            if (this.numBlocksToUpdate > 0) {
                PlayerManager.getPlayerInstancesToUpdate(this.playerManager).remove(this);
            }
            this.playerManager.getMinecraftServer().chunkProviderServer.func_374_c(this.chunkX, this.chunkZ);
        }
        entityplayermp.loadedChunks.remove(this.currentChunk);
        if (entityplayermp.field_420_ah.contains(this.currentChunk)) {
            entityplayermp.playerNetServerHandler.sendPacket(new Packet50PreChunk(this.chunkX, this.chunkZ, false));
        }
    }

    public void markBlockNeedsUpdate(int i, int j, int k) {
        if (this.numBlocksToUpdate == 0) {
            PlayerManager.getPlayerInstancesToUpdate(this.playerManager).add(this);
            this.minX = this.maxX = i;
            this.minY = this.maxY = j;
            this.minZ = this.maxZ = k;
        }
        if (this.minX > i) {
            this.minX = i;
        }
        if (this.maxX < i) {
            this.maxX = i;
        }
        if (this.minY > j) {
            this.minY = j;
        }
        if (this.maxY < j) {
            this.maxY = j;
        }
        if (this.minZ > k) {
            this.minZ = k;
        }
        if (this.maxZ < k) {
            this.maxZ = k;
        }
        if (this.numBlocksToUpdate < 10) {
            short word0 = (short)(i << 12 | k << 8 | j);
            int l = 0;
            while (l < this.numBlocksToUpdate) {
                if (this.blocksToUpdate[l] == word0) {
                    return;
                }
                ++l;
            }
            this.blocksToUpdate[this.numBlocksToUpdate++] = word0;
        }
    }

    public void sendPacketToPlayersInInstance(Packet packet) {
        int i = 0;
        while (i < this.players.size()) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)this.players.get(i);
            if (entityplayermp.field_420_ah.contains(this.currentChunk)) {
                entityplayermp.playerNetServerHandler.sendPacket(packet);
            }
            ++i;
        }
    }

    public void onUpdate() {
        WorldServer worldserver = this.playerManager.getMinecraftServer();
        if (this.numBlocksToUpdate == 0) {
            return;
        }
        if (this.numBlocksToUpdate == 1) {
            int i = this.chunkX * 16 + this.minX;
            int l = this.minY;
            int k1 = this.chunkZ * 16 + this.minZ;
            this.sendPacketToPlayersInInstance(new Packet53BlockChange(i, l, k1, worldserver));
            if (Block.isBlockContainer[worldserver.getBlockId(i, l, k1)]) {
                this.updateTileEntity(worldserver.getBlockTileEntity(i, l, k1));
            }
        } else if (this.numBlocksToUpdate == 10) {
            this.minY = this.minY / 2 * 2;
            this.maxY = (this.maxY / 2 + 1) * 2;
            int j = this.minX + this.chunkX * 16;
            int i1 = this.minY;
            int l1 = this.minZ + this.chunkZ * 16;
            int j2 = this.maxX - this.minX + 1;
            int l2 = this.maxY - this.minY + 2;
            int i3 = this.maxZ - this.minZ + 1;
            this.sendPacketToPlayersInInstance(new Packet51MapChunk(j, i1, l1, j2, l2, i3, worldserver));
            List list = worldserver.getTileEntityList(j, i1, l1, j + j2, i1 + l2, l1 + i3);
            int j3 = 0;
            while (j3 < list.size()) {
                this.updateTileEntity((TileEntity)list.get(j3));
                ++j3;
            }
        } else {
            this.sendPacketToPlayersInInstance(new Packet52MultiBlockChange(this.chunkX, this.chunkZ, this.blocksToUpdate, this.numBlocksToUpdate, worldserver));
            int k = 0;
            while (k < this.numBlocksToUpdate) {
                int j1 = this.chunkX * 16 + (this.numBlocksToUpdate >> 12 & 0xF);
                int i2 = this.numBlocksToUpdate & 0xFF;
                int k2 = this.chunkZ * 16 + (this.numBlocksToUpdate >> 8 & 0xF);
                if (Block.isBlockContainer[worldserver.getBlockId(j1, i2, k2)]) {
                    System.out.println("Sending!");
                    this.updateTileEntity(worldserver.getBlockTileEntity(j1, i2, k2));
                }
                ++k;
            }
        }
        this.numBlocksToUpdate = 0;
    }

    private void updateTileEntity(TileEntity tileentity) {
        Packet packet;
        if (tileentity != null && (packet = tileentity.getDescriptionPacket()) != null) {
            this.sendPacketToPlayersInInstance(packet);
        }
    }
}

