/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.server;

import com.mojang.minecraft.MinecraftException;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.level.chunk.ChunkLoader;
import com.mojang.minecraft.level.generate.IChunkLoader;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.server.IPlayerFileData;
import com.mojang.minecraft.server.ISaveHandler;
import com.mojang.minecraft.server.WorldInfo;
import com.mojang.minecraft.server.WorldProvider;
import com.mojang.minecraft.server.WorldProviderHell;
import com.mojang.minecraft.util.CompressedStreamTools;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

public class PlayerNBTManager
implements IPlayerFileData,
ISaveHandler {
    private static final Logger logger = Logger.getLogger("Minecraft");
    private final File worldDir;
    private final File worldFile;
    private final File field_28112_d;
    private final long field_22100_d = System.currentTimeMillis();

    public PlayerNBTManager(File file, String s, boolean flag) {
        this.worldDir = new File(file, s);
        this.worldDir.mkdirs();
        this.worldFile = new File(this.worldDir, "players");
        this.field_28112_d = new File(this.worldDir, "data");
        this.field_28112_d.mkdirs();
        if (flag) {
            this.worldFile.mkdirs();
        }
        this.func_22098_f();
    }

    private void func_22098_f() {
        try {
            File file = new File(this.worldDir, "session.lock");
            DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file));
            try {
                dataoutputstream.writeLong(this.field_22100_d);
            }
            finally {
                dataoutputstream.close();
            }
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            throw new RuntimeException("Failed to check session lock, aborting");
        }
    }

    protected File getWorldDir() {
        return this.worldDir;
    }

    public void func_22091_b() {
        try {
            File file = new File(this.worldDir, "session.lock");
            DataInputStream datainputstream = new DataInputStream(new FileInputStream(file));
            try {
                if (datainputstream.readLong() != this.field_22100_d) {
                    throw new MinecraftException("The save is being accessed from another location, aborting");
                }
            }
            finally {
                datainputstream.close();
            }
        }
        catch (IOException ioexception) {
            throw new MinecraftException("Failed to check session lock, aborting");
        }
    }

    public IChunkLoader func_22092_a(WorldProvider worldprovider) {
        if (worldprovider instanceof WorldProviderHell) {
            File file = new File(this.worldDir, "DIM-1");
            file.mkdirs();
            return new ChunkLoader(file, true);
        }
        return new ChunkLoader(this.worldDir, true);
    }

    public WorldInfo func_22096_c() {
        File file = new File(this.worldDir, "level.dat");
        if (file.exists()) {
            try {
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_1138_a(new FileInputStream(file));
                NBTTagCompound nbttagcompound2 = nbttagcompound.getCompoundTag("Data");
                return new WorldInfo(nbttagcompound2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((file = new File(this.worldDir, "level.dat_old")).exists()) {
            try {
                NBTTagCompound nbttagcompound1 = CompressedStreamTools.func_1138_a(new FileInputStream(file));
                NBTTagCompound nbttagcompound3 = nbttagcompound1.getCompoundTag("Data");
                return new WorldInfo(nbttagcompound3);
            }
            catch (Exception exception1) {
                exception1.printStackTrace();
            }
        }
        return null;
    }

    public void func_22095_a(WorldInfo worldinfo, List list) {
        NBTTagCompound nbttagcompound = worldinfo.func_22183_a(list);
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.setTag("Data", nbttagcompound);
        try {
            File file = new File(this.worldDir, "level.dat_new");
            File file1 = new File(this.worldDir, "level.dat_old");
            File file2 = new File(this.worldDir, "level.dat");
            CompressedStreamTools.writeGzippedCompoundToOutputStream(nbttagcompound1, new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void func_22094_a(WorldInfo worldinfo) {
        NBTTagCompound nbttagcompound = worldinfo.func_22185_a();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.setTag("Data", nbttagcompound);
        try {
            File file = new File(this.worldDir, "level.dat_new");
            File file1 = new File(this.worldDir, "level.dat_old");
            File file2 = new File(this.worldDir, "level.dat");
            CompressedStreamTools.writeGzippedCompoundToOutputStream(nbttagcompound1, new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void writePlayerData(EntityPlayer entityplayer) {
        try {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            entityplayer.writeToNBT(nbttagcompound);
            File file = new File(this.worldFile, "_tmp_.dat");
            File file1 = new File(this.worldFile, entityplayer.username + ".dat");
            CompressedStreamTools.writeGzippedCompoundToOutputStream(nbttagcompound, new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file.renameTo(file1);
        }
        catch (Exception exception) {
            logger.warning("Failed to save player data for " + entityplayer.username);
        }
    }

    public void readPlayerData(EntityPlayer entityplayer) {
        NBTTagCompound nbttagcompound = this.getPlayerData(entityplayer.username);
        if (nbttagcompound != null) {
            entityplayer.readFromNBT(nbttagcompound);
        }
    }

    public NBTTagCompound getPlayerData(String s) {
        try {
            File file = new File(this.worldFile, s + ".dat");
            if (file.exists()) {
                return CompressedStreamTools.func_1138_a(new FileInputStream(file));
            }
        }
        catch (Exception exception) {
            logger.warning("Failed to load player data for " + s);
        }
        return null;
    }

    public IPlayerFileData func_22090_d() {
        return this;
    }

    public void func_22093_e() {
    }

    public File func_28111_b(String s) {
        return new File(this.field_28112_d, s + ".dat");
    }
}

