/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertyManager {
    public static Logger logger = Logger.getLogger("Minecraft");
    private Properties serverProperties = new Properties();
    private File serverPropertiesFile;

    public PropertyManager(File file) {
        this.serverPropertiesFile = file;
        if (file.exists()) {
            try {
                this.serverProperties.load(new FileInputStream(file));
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Failed to load " + file, exception);
                this.generateNewProperties();
            }
        } else {
            logger.log(Level.WARNING, file + " does not exist");
            this.generateNewProperties();
        }
    }

    public void generateNewProperties() {
        logger.log(Level.INFO, "Generating new properties file");
        this.saveProperties();
    }

    public void saveProperties() {
        try {
            this.serverProperties.store(new FileOutputStream(this.serverPropertiesFile), "Minecraft server properties");
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to save " + this.serverPropertiesFile, exception);
            this.generateNewProperties();
        }
    }

    public String getStringProperty(String s, String s1) {
        if (!this.serverProperties.containsKey(s)) {
            this.serverProperties.setProperty(s, s1);
            this.saveProperties();
        }
        return this.serverProperties.getProperty(s, s1);
    }

    public int getIntProperty(String s, int i) {
        try {
            return Integer.parseInt(this.getStringProperty(s, "" + i));
        }
        catch (Exception exception) {
            this.serverProperties.setProperty(s, "" + i);
            return i;
        }
    }

    public boolean getBooleanProperty(String s, boolean flag) {
        try {
            return Boolean.parseBoolean(this.getStringProperty(s, "" + flag));
        }
        catch (Exception exception) {
            this.serverProperties.setProperty(s, "" + flag);
            return flag;
        }
    }

    public void setProperty(String s, boolean flag) {
        this.serverProperties.setProperty(s, "" + flag);
        this.saveProperties();
    }
}

