/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.server;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntityPlayerMP;
import com.mojang.minecraft.entity.item.ItemInWorldManager;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.level.chunk.ChunkCoordinates;
import com.mojang.minecraft.network.NetLoginHandler;
import com.mojang.minecraft.network.packet.Packet;
import com.mojang.minecraft.network.packet.Packet3Chat;
import com.mojang.minecraft.network.packet.Packet4UpdateTime;
import com.mojang.minecraft.network.packet.Packet70Bed;
import com.mojang.minecraft.network.packet.Packet9Respawn;
import com.mojang.minecraft.server.IPlayerFileData;
import com.mojang.minecraft.server.MinecraftServer;
import com.mojang.minecraft.server.PlayerManager;
import com.mojang.minecraft.server.Teleporter;
import com.mojang.minecraft.server.WorldServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class ServerConfigurationManager {
    public static Logger logger = Logger.getLogger("Minecraft");
    public List playerEntities = new ArrayList();
    private MinecraftServer mcServer;
    private PlayerManager[] playerManagerObj;
    private int maxPlayers;
    private Set bannedPlayers = new HashSet();
    private Set bannedIPs = new HashSet();
    private Set ops = new HashSet();
    private Set whiteListedIPs = new HashSet();
    private File bannedPlayersFile;
    private File ipBanFile;
    private File opFile;
    private File whitelistPlayersFile;
    private IPlayerFileData playerNBTManagerObj;
    private boolean whiteListEnforced;
    private String worldType;

    public ServerConfigurationManager(MinecraftServer minecraftserver) {
        this.playerManagerObj = new PlayerManager[2];
        this.mcServer = minecraftserver;
        this.bannedPlayersFile = minecraftserver.getFile("banned-players.txt");
        this.ipBanFile = minecraftserver.getFile("banned-ips.txt");
        this.opFile = minecraftserver.getFile("ops.txt");
        this.whitelistPlayersFile = minecraftserver.getFile("white-list.txt");
        int i = minecraftserver.propertyManagerObj.getIntProperty("view-distance", 10);
        this.playerManagerObj[0] = new PlayerManager(minecraftserver, 0, i);
        this.playerManagerObj[1] = new PlayerManager(minecraftserver, -1, i);
        this.maxPlayers = minecraftserver.propertyManagerObj.getIntProperty("max-players", 20);
        this.whiteListEnforced = minecraftserver.propertyManagerObj.getBooleanProperty("white-list", false);
        this.worldType = minecraftserver.propertyManagerObj.getStringProperty("world-type", "normal");
        this.readBannedPlayers();
        this.loadBannedList();
        this.loadOps();
        this.loadWhiteList();
        this.writeBannedPlayers();
        this.saveBannedList();
        this.saveOps();
        this.saveWhiteList();
    }

    public void setPlayerManager(WorldServer[] aworldserver) {
        this.playerNBTManagerObj = aworldserver[0].getWorldFile().func_22090_d();
    }

    public void func_28172_a(EntityPlayerMP entityplayermp) {
        this.playerManagerObj[0].removePlayer(entityplayermp);
        this.playerManagerObj[1].removePlayer(entityplayermp);
        this.getPlayerManager(entityplayermp.dimension).addPlayer(entityplayermp);
        WorldServer worldserver = this.mcServer.getWorldManager(entityplayermp.dimension);
        worldserver.chunkProviderServer.loadChunk((int)entityplayermp.posX >> 4, (int)entityplayermp.posZ >> 4);
    }

    public int getMaxTrackingDistance() {
        return this.playerManagerObj[0].getMaxTrackingDistance();
    }

    private PlayerManager getPlayerManager(int i) {
        return i != -1 ? this.playerManagerObj[0] : this.playerManagerObj[1];
    }

    public void readPlayerDataFromFile(EntityPlayerMP entityplayermp) {
        this.playerNBTManagerObj.readPlayerData(entityplayermp);
    }

    public void playerLoggedIn(EntityPlayerMP entityplayermp) {
        this.playerEntities.add(entityplayermp);
        WorldServer worldserver = this.mcServer.getWorldManager(entityplayermp.dimension);
        worldserver.chunkProviderServer.loadChunk((int)entityplayermp.posX >> 4, (int)entityplayermp.posZ >> 4);
        while (worldserver.getCollidingBoundingBoxes(entityplayermp, entityplayermp.boundingBox).size() != 0) {
            entityplayermp.setPosition(entityplayermp.posX, entityplayermp.posY + 1.0, entityplayermp.posZ);
        }
        worldserver.entityJoinedWorld(entityplayermp);
        this.getPlayerManager(entityplayermp.dimension).addPlayer(entityplayermp);
    }

    public void func_613_b(EntityPlayerMP entityplayermp) {
        this.getPlayerManager(entityplayermp.dimension).func_543_c(entityplayermp);
    }

    public void playerLoggedOut(EntityPlayerMP entityplayermp) {
        this.playerNBTManagerObj.writePlayerData(entityplayermp);
        this.mcServer.getWorldManager(entityplayermp.dimension).removePlayerForLogoff(entityplayermp);
        this.playerEntities.remove(entityplayermp);
        this.getPlayerManager(entityplayermp.dimension).removePlayer(entityplayermp);
    }

    public EntityPlayerMP login(NetLoginHandler netloginhandler, String s) {
        if (this.bannedPlayers.contains(s.trim().toLowerCase())) {
            netloginhandler.kickUser("You are banned from this server!");
            return null;
        }
        if (!this.isAllowedToLogin(s)) {
            netloginhandler.kickUser("You are not white-listed on this server!");
            return null;
        }
        String s1 = netloginhandler.netManager.getRemoteAddress().toString();
        s1 = s1.substring(s1.indexOf("/") + 1);
        if (this.bannedIPs.contains(s1 = s1.substring(0, s1.indexOf(":")))) {
            netloginhandler.kickUser("Your IP address is banned from this server!");
            return null;
        }
        if (this.playerEntities.size() >= this.maxPlayers) {
            netloginhandler.kickUser("The server is full!");
            return null;
        }
        int i = 0;
        while (i < this.playerEntities.size()) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)this.playerEntities.get(i);
            if (entityplayermp.username.equalsIgnoreCase(s)) {
                entityplayermp.playerNetServerHandler.kickPlayer("You logged in from another location");
            }
            ++i;
        }
        return new EntityPlayerMP(this.mcServer, this.mcServer.getWorldManager(0), s, new ItemInWorldManager(this.mcServer.getWorldManager(0)));
    }

    public EntityPlayerMP recreatePlayerEntity(EntityPlayerMP entityplayermp, int i) {
        this.mcServer.getEntityTracker(entityplayermp.dimension).removeTrackedPlayerSymmetric(entityplayermp);
        this.mcServer.getEntityTracker(entityplayermp.dimension).untrackEntity(entityplayermp);
        this.getPlayerManager(entityplayermp.dimension).removePlayer(entityplayermp);
        this.playerEntities.remove(entityplayermp);
        this.mcServer.getWorldManager(entityplayermp.dimension).removePlayer(entityplayermp);
        ChunkCoordinates chunkcoordinates = entityplayermp.getSpawnChunk();
        entityplayermp.dimension = i;
        EntityPlayerMP entityplayermp1 = new EntityPlayerMP(this.mcServer, this.mcServer.getWorldManager(entityplayermp.dimension), entityplayermp.username, new ItemInWorldManager(this.mcServer.getWorldManager(entityplayermp.dimension)));
        entityplayermp1.entityId = entityplayermp.entityId;
        entityplayermp1.playerNetServerHandler = entityplayermp.playerNetServerHandler;
        WorldServer worldserver = this.mcServer.getWorldManager(entityplayermp.dimension);
        if (chunkcoordinates != null) {
            System.out.println("Spawn Coords not null!");
            ChunkCoordinates chunkcoordinates1 = EntityPlayer.func_25051_a(this.mcServer.getWorldManager(entityplayermp.dimension), chunkcoordinates);
            if (chunkcoordinates1 != null) {
                System.out.println("Found new spawn!");
                entityplayermp1.setLocationAndAngles((float)chunkcoordinates1.posX + 0.5f, (float)chunkcoordinates1.posY + 0.1f, (float)chunkcoordinates1.posZ + 0.5f, 0.0f, 0.0f);
                entityplayermp1.setSpawnChunk(chunkcoordinates);
            } else {
                System.out.println("Didn't find new spawn!");
                entityplayermp1.playerNetServerHandler.sendPacket(new Packet70Bed(0));
            }
        }
        worldserver.chunkProviderServer.loadChunk((int)entityplayermp1.posX >> 4, (int)entityplayermp1.posZ >> 4);
        while (worldserver.getCollidingBoundingBoxes(entityplayermp1, entityplayermp1.boundingBox).size() != 0) {
            entityplayermp1.setPosition(entityplayermp1.posX, entityplayermp1.posY + 1.0, entityplayermp1.posZ);
        }
        entityplayermp1.playerNetServerHandler.sendPacket(new Packet9Respawn((byte)entityplayermp1.dimension));
        entityplayermp1.playerNetServerHandler.teleportTo(entityplayermp1.posX, entityplayermp1.posY, entityplayermp1.posZ, entityplayermp1.rotationYaw, entityplayermp1.rotationPitch);
        this.func_28170_a(entityplayermp1, worldserver);
        this.getPlayerManager(entityplayermp1.dimension).addPlayer(entityplayermp1);
        worldserver.entityJoinedWorld(entityplayermp1);
        this.playerEntities.add(entityplayermp1);
        entityplayermp1.func_20057_k();
        entityplayermp1.func_22068_s();
        return entityplayermp1;
    }

    public void sendPlayerToOtherDimension(EntityPlayerMP entityplayermp) {
        WorldServer worldserver = this.mcServer.getWorldManager(entityplayermp.dimension);
        int i = 0;
        i = entityplayermp.dimension == -1 ? 0 : -1;
        entityplayermp.dimension = i;
        WorldServer worldserver1 = this.mcServer.getWorldManager(entityplayermp.dimension);
        entityplayermp.playerNetServerHandler.sendPacket(new Packet9Respawn((byte)entityplayermp.dimension));
        worldserver.removePlayer(entityplayermp);
        entityplayermp.isDead = false;
        double d = entityplayermp.posX;
        double d1 = entityplayermp.posZ;
        double d2 = 8.0;
        if (entityplayermp.dimension == -1) {
            entityplayermp.setLocationAndAngles(d /= d2, entityplayermp.posY, d1 /= d2, entityplayermp.rotationYaw, entityplayermp.rotationPitch);
            if (entityplayermp.isEntityAlive()) {
                worldserver.updateEntityWithOptionalForce(entityplayermp, false);
            }
        } else {
            entityplayermp.setLocationAndAngles(d *= d2, entityplayermp.posY, d1 *= d2, entityplayermp.rotationYaw, entityplayermp.rotationPitch);
            if (entityplayermp.isEntityAlive()) {
                worldserver.updateEntityWithOptionalForce(entityplayermp, false);
            }
        }
        if (entityplayermp.isEntityAlive()) {
            worldserver1.entityJoinedWorld(entityplayermp);
            entityplayermp.setLocationAndAngles(d, entityplayermp.posY, d1, entityplayermp.rotationYaw, entityplayermp.rotationPitch);
            worldserver1.updateEntityWithOptionalForce(entityplayermp, false);
            worldserver1.chunkProviderServer.chunkLoadOverride = true;
            new Teleporter().setExitLocation(worldserver1, entityplayermp);
            worldserver1.chunkProviderServer.chunkLoadOverride = false;
        }
        this.func_28172_a(entityplayermp);
        entityplayermp.playerNetServerHandler.teleportTo(entityplayermp.posX, entityplayermp.posY, entityplayermp.posZ, entityplayermp.rotationYaw, entityplayermp.rotationPitch);
        entityplayermp.setWorldHandler(worldserver1);
        this.func_28170_a(entityplayermp, worldserver1);
        this.func_30008_g(entityplayermp);
    }

    public void onTick() {
        int i = 0;
        while (i < this.playerManagerObj.length) {
            this.playerManagerObj[i].updatePlayerInstances();
            ++i;
        }
    }

    public void markBlockNeedsUpdate(int i, int j, int k, int l) {
        this.getPlayerManager(l).markBlockNeedsUpdate(i, j, k);
    }

    public void sendPacketToAllPlayers(Packet packet) {
        int i = 0;
        while (i < this.playerEntities.size()) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)this.playerEntities.get(i);
            entityplayermp.playerNetServerHandler.sendPacket(packet);
            ++i;
        }
    }

    public void sendPacketToAllPlayersInDimension(Packet packet, int i) {
        int j = 0;
        while (j < this.playerEntities.size()) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)this.playerEntities.get(j);
            if (entityplayermp.dimension == i) {
                entityplayermp.playerNetServerHandler.sendPacket(packet);
            }
            ++j;
        }
    }

    public String getPlayerList() {
        String s = "";
        int i = 0;
        while (i < this.playerEntities.size()) {
            if (i > 0) {
                s = s + ", ";
            }
            s = s + ((EntityPlayerMP)this.playerEntities.get((int)i)).username;
            ++i;
        }
        return s;
    }

    public void banPlayer(String s) {
        this.bannedPlayers.add(s.toLowerCase());
        this.writeBannedPlayers();
    }

    public void pardonPlayer(String s) {
        this.bannedPlayers.remove(s.toLowerCase());
        this.writeBannedPlayers();
    }

    private void readBannedPlayers() {
        try {
            this.bannedPlayers.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.bannedPlayersFile));
            String s = "";
            while ((s = bufferedreader.readLine()) != null) {
                this.bannedPlayers.add(s.trim().toLowerCase());
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to load ban list: " + exception);
        }
    }

    private void writeBannedPlayers() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.bannedPlayersFile, false));
            for (String s : this.bannedPlayers) {
                printwriter.println(s);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to save ban list: " + exception);
        }
    }

    public void banIP(String s) {
        this.bannedIPs.add(s.toLowerCase());
        this.saveBannedList();
    }

    public void pardonIP(String s) {
        this.bannedIPs.remove(s.toLowerCase());
        this.saveBannedList();
    }

    private void loadBannedList() {
        try {
            this.bannedIPs.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.ipBanFile));
            String s = "";
            while ((s = bufferedreader.readLine()) != null) {
                this.bannedIPs.add(s.trim().toLowerCase());
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to load ip ban list: " + exception);
        }
    }

    private void saveBannedList() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.ipBanFile, false));
            for (String s : this.bannedIPs) {
                printwriter.println(s);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to save ip ban list: " + exception);
        }
    }

    public void opPlayer(String s) {
        this.ops.add(s.toLowerCase());
        this.saveOps();
    }

    public void deopPlayer(String s) {
        this.ops.remove(s.toLowerCase());
        this.saveOps();
    }

    private void loadOps() {
        try {
            this.ops.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.opFile));
            String s = "";
            while ((s = bufferedreader.readLine()) != null) {
                this.ops.add(s.trim().toLowerCase());
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to load ip ban list: " + exception);
        }
    }

    private void saveOps() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.opFile, false));
            for (String s : this.ops) {
                printwriter.println(s);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to save ip ban list: " + exception);
        }
    }

    private void loadWhiteList() {
        try {
            this.whiteListedIPs.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.whitelistPlayersFile));
            String s = "";
            while ((s = bufferedreader.readLine()) != null) {
                this.whiteListedIPs.add(s.trim().toLowerCase());
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to load white-list: " + exception);
        }
    }

    private void saveWhiteList() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.whitelistPlayersFile, false));
            for (String s : this.whiteListedIPs) {
                printwriter.println(s);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to save white-list: " + exception);
        }
    }

    public boolean isAllowedToLogin(String s) {
        s = s.trim().toLowerCase();
        return !this.whiteListEnforced || this.ops.contains(s) || this.whiteListedIPs.contains(s);
    }

    public boolean isOp(String s) {
        return this.ops.contains(s.trim().toLowerCase());
    }

    public EntityPlayerMP getPlayerEntity(String s) {
        int i = 0;
        while (i < this.playerEntities.size()) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)this.playerEntities.get(i);
            if (entityplayermp.username.equalsIgnoreCase(s)) {
                return entityplayermp;
            }
            ++i;
        }
        return null;
    }

    public void sendChatMessageToPlayer(String s, String s1) {
        EntityPlayerMP entityplayermp = this.getPlayerEntity(s);
        if (entityplayermp != null) {
            entityplayermp.playerNetServerHandler.sendPacket(new Packet3Chat(s1));
        }
    }

    public void sendPacketToPlayersAroundPoint(double d, double d1, double d2, double d3, int i, Packet packet) {
        this.sendPacketToPlayersWithinArea(null, d, d1, d2, d3, i, packet);
    }

    public void sendPacketToPlayersWithinArea(EntityPlayer entityplayer, double boundX, double boundY, double boundZ, double area, int dimension, Packet packet) {
        int j = 0;
        while (j < this.playerEntities.size()) {
            double distZ;
            double distY;
            double distX;
            EntityPlayerMP entityplayermp = (EntityPlayerMP)this.playerEntities.get(j);
            if (entityplayermp != entityplayer && entityplayermp.dimension == dimension && (distX = boundX - entityplayermp.posX) * distX + (distY = boundY - entityplayermp.posY) * distY + (distZ = boundZ - entityplayermp.posZ) * distZ < area * area) {
                entityplayermp.playerNetServerHandler.sendPacket(packet);
            }
            ++j;
        }
    }

    public void sendChatMessageToAllOps(String s) {
        Packet3Chat packet3chat = new Packet3Chat(s);
        int i = 0;
        while (i < this.playerEntities.size()) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)this.playerEntities.get(i);
            if (this.isOp(entityplayermp.username)) {
                entityplayermp.playerNetServerHandler.sendPacket(packet3chat);
            }
            ++i;
        }
    }

    public boolean sendPacketToPlayer(String s, Packet packet) {
        EntityPlayerMP entityplayermp = this.getPlayerEntity(s);
        if (entityplayermp != null) {
            entityplayermp.playerNetServerHandler.sendPacket(packet);
            return true;
        }
        return false;
    }

    public void savePlayerStates() {
        int i = 0;
        while (i < this.playerEntities.size()) {
            this.playerNBTManagerObj.writePlayerData((EntityPlayer)this.playerEntities.get(i));
            ++i;
        }
    }

    public void sentTileEntityToPlayer(int i, int j, int k, TileEntity tileentity) {
    }

    public void addToWhiteList(String s) {
        this.whiteListedIPs.add(s);
        this.saveWhiteList();
    }

    public void removeFromWhiteList(String s) {
        this.whiteListedIPs.remove(s);
        this.saveWhiteList();
    }

    public Set getWhiteListedIPs() {
        return this.whiteListedIPs;
    }

    public void reloadWhiteList() {
        this.loadWhiteList();
    }

    public void func_28170_a(EntityPlayerMP entityplayermp, WorldServer worldserver) {
        entityplayermp.playerNetServerHandler.sendPacket(new Packet4UpdateTime(worldserver.getWorldTime()));
        if (worldserver.func_27068_v()) {
            entityplayermp.playerNetServerHandler.sendPacket(new Packet70Bed(1));
        }
    }

    public void func_30008_g(EntityPlayerMP entityplayermp) {
        entityplayermp.func_28017_a(entityplayermp.personalCraftingInventory);
        entityplayermp.func_30001_B();
    }
}

