/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.server;

import com.mojang.minecraft.gui.GuiLogOutputHandler;
import com.mojang.minecraft.gui.GuiStatsComponent;
import com.mojang.minecraft.gui.ICommandListener;
import com.mojang.minecraft.server.MinecraftServer;
import com.mojang.minecraft.server.PlayerListBox;
import com.mojang.minecraft.server.ServerGuiCommandListener;
import com.mojang.minecraft.server.ServerGuiFocusAdapter;
import com.mojang.minecraft.server.ServerWindowAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ServerGUI
extends JComponent
implements ICommandListener {
    public static Logger logger = Logger.getLogger("Minecraft");
    private MinecraftServer mcServer;

    public static void initGui(MinecraftServer minecraftserver) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ServerGUI servergui = new ServerGUI(minecraftserver);
        JFrame jframe = new JFrame("Minecraft server");
        jframe.add(servergui);
        jframe.pack();
        jframe.setLocationRelativeTo(null);
        jframe.setVisible(true);
        jframe.addWindowListener(new ServerWindowAdapter(minecraftserver));
    }

    public ServerGUI(MinecraftServer minecraftserver) {
        this.mcServer = minecraftserver;
        this.setPreferredSize(new Dimension(854, 480));
        this.setLayout(new BorderLayout());
        try {
            this.add((Component)this.getLogComponent(), "Center");
            this.add((Component)this.getStatsComponent(), "West");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private JComponent getStatsComponent() {
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.add((Component)new GuiStatsComponent(), "North");
        jpanel.add((Component)this.getPlayerListComponent(), "Center");
        jpanel.setBorder(new TitledBorder(new EtchedBorder(), "Stats"));
        return jpanel;
    }

    private JComponent getPlayerListComponent() {
        PlayerListBox playerlistbox = new PlayerListBox(this.mcServer);
        JScrollPane jscrollpane = new JScrollPane(playerlistbox, 22, 30);
        jscrollpane.setBorder(new TitledBorder(new EtchedBorder(), "Players"));
        return jscrollpane;
    }

    private JComponent getLogComponent() {
        JPanel jpanel = new JPanel(new BorderLayout());
        JTextArea jtextarea = new JTextArea();
        logger.addHandler(new GuiLogOutputHandler(jtextarea));
        JScrollPane jscrollpane = new JScrollPane(jtextarea, 22, 30);
        jtextarea.setEditable(false);
        JTextField jtextfield = new JTextField();
        jtextfield.addActionListener(new ServerGuiCommandListener(this, jtextfield));
        jtextarea.addFocusListener(new ServerGuiFocusAdapter(this));
        jpanel.add((Component)jscrollpane, "Center");
        jpanel.add((Component)jtextfield, "South");
        jpanel.setBorder(new TitledBorder(new EtchedBorder(), "Log and chat"));
        return jpanel;
    }

    public void log(String s) {
        logger.info(s);
    }

    public String getUsername() {
        return "CONSOLE";
    }

    static MinecraftServer getMinecraftServer(ServerGUI servergui) {
        return servergui.mcServer;
    }
}

