/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.server;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.ChunkCoordIntPair;
import com.mojang.minecraft.level.generate.noise.NoiseGeneratorOctaves2;
import com.mojang.minecraft.server.BiomeGenBase;
import java.util.Random;

public class WorldChunkManager {
    private NoiseGeneratorOctaves2 field_4255_e;
    private NoiseGeneratorOctaves2 field_4254_f;
    private NoiseGeneratorOctaves2 field_4253_g;
    public double[] temperature;
    public double[] humidity;
    public double[] field_4257_c;
    public BiomeGenBase[] field_4256_d;

    protected WorldChunkManager() {
    }

    public WorldChunkManager(World world) {
        this.field_4255_e = new NoiseGeneratorOctaves2(new Random(world.getRandomSeed() * 9871L), 4);
        this.field_4254_f = new NoiseGeneratorOctaves2(new Random(world.getRandomSeed() * 39811L), 4);
        this.field_4253_g = new NoiseGeneratorOctaves2(new Random(world.getRandomSeed() * 543321L), 2);
    }

    public BiomeGenBase getBiomeTypeAt(ChunkCoordIntPair chunkcoordintpair) {
        return this.getBiomeGenAt(chunkcoordintpair.chunkXPos << 4, chunkcoordintpair.chunkZPos << 4);
    }

    public BiomeGenBase getBiomeGenAt(int i, int j) {
        return this.func_4065_a(i, j, 1, 1)[0];
    }

    public BiomeGenBase[] func_4065_a(int i, int j, int k, int l) {
        this.field_4256_d = this.loadBlockGeneratorData(this.field_4256_d, i, j, k, l);
        return this.field_4256_d;
    }

    public double[] getTemperatures(double[] ad, int i, int j, int k, int l) {
        if (ad == null || ad.length < k * l) {
            ad = new double[k * l];
        }
        ad = this.field_4255_e.func_4101_a(ad, i, j, k, l, 0.025f, 0.025f, 0.25);
        this.field_4257_c = this.field_4253_g.func_4101_a(this.field_4257_c, i, j, k, l, 0.25, 0.25, 0.5882352941176471);
        int i1 = 0;
        int j1 = 0;
        while (j1 < k) {
            int k1 = 0;
            while (k1 < l) {
                double d = this.field_4257_c[i1] * 1.1 + 0.5;
                double d1 = 0.01;
                double d2 = 1.0 - d1;
                double d3 = (ad[i1] * 0.15 + 0.7) * d2 + d * d1;
                if ((d3 = 1.0 - (1.0 - d3) * (1.0 - d3)) < 0.0) {
                    d3 = 0.0;
                }
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                ad[i1] = d3;
                ++i1;
                ++k1;
            }
            ++j1;
        }
        return ad;
    }

    public BiomeGenBase[] loadBlockGeneratorData(BiomeGenBase[] abiomegenbase, int i, int j, int k, int l) {
        if (abiomegenbase == null || abiomegenbase.length < k * l) {
            abiomegenbase = new BiomeGenBase[k * l];
        }
        this.temperature = this.field_4255_e.func_4101_a(this.temperature, i, j, k, k, 0.025f, 0.025f, 0.25);
        this.humidity = this.field_4254_f.func_4101_a(this.humidity, i, j, k, k, 0.05f, 0.05f, 0.3333333333333333);
        this.field_4257_c = this.field_4253_g.func_4101_a(this.field_4257_c, i, j, k, k, 0.25, 0.25, 0.5882352941176471);
        int i1 = 0;
        int j1 = 0;
        while (j1 < k) {
            int k1 = 0;
            while (k1 < l) {
                double d = this.field_4257_c[i1] * 1.1 + 0.5;
                double d1 = 0.01;
                double d2 = 1.0 - d1;
                double d3 = (this.temperature[i1] * 0.15 + 0.7) * d2 + d * d1;
                d1 = 0.002;
                d2 = 1.0 - d1;
                double d4 = (this.humidity[i1] * 0.15 + 0.5) * d2 + d * d1;
                if ((d3 = 1.0 - (1.0 - d3) * (1.0 - d3)) < 0.0) {
                    d3 = 0.0;
                }
                if (d4 < 0.0) {
                    d4 = 0.0;
                }
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                if (d4 > 1.0) {
                    d4 = 1.0;
                }
                this.temperature[i1] = d3;
                this.humidity[i1] = d4;
                abiomegenbase[i1++] = BiomeGenBase.getBiomeFromLookup(d3, d4);
                ++k1;
            }
            ++j1;
        }
        return abiomegenbase;
    }
}

