/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.server;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.nbt.NBTTagCompound;
import java.util.List;

public class WorldInfo {
    private long randomSeed;
    private int spawnX;
    private int spawnY;
    private int spawnZ;
    private long worldTime;
    private long lastTimePlayed;
    private long sizeOnDisk;
    private NBTTagCompound field_22195_h;
    private int field_22194_i;
    private String levelName;
    private int saveVersion;
    private boolean isRaining;
    private int rainTime;
    private boolean isThundering;
    private int thunderTime;
    private int worldType;

    public WorldInfo(NBTTagCompound nbttagcompound) {
        this.randomSeed = nbttagcompound.getLong("RandomSeed");
        this.spawnX = nbttagcompound.getInteger("SpawnX");
        this.spawnY = nbttagcompound.getInteger("SpawnY");
        this.spawnZ = nbttagcompound.getInteger("SpawnZ");
        this.worldTime = nbttagcompound.getLong("Time");
        this.lastTimePlayed = nbttagcompound.getLong("LastPlayed");
        this.sizeOnDisk = nbttagcompound.getLong("SizeOnDisk");
        this.levelName = nbttagcompound.getString("LevelName");
        this.saveVersion = nbttagcompound.getInteger("version");
        this.rainTime = nbttagcompound.getInteger("rainTime");
        this.isRaining = nbttagcompound.getBoolean("raining");
        this.thunderTime = nbttagcompound.getInteger("thunderTime");
        this.isThundering = nbttagcompound.getBoolean("thundering");
        this.worldType = nbttagcompound.getInteger("WorldType");
        if (nbttagcompound.hasKey("Player")) {
            this.field_22195_h = nbttagcompound.getCompoundTag("Player");
            this.field_22194_i = this.field_22195_h.getInteger("Dimension");
        }
    }

    public WorldInfo(long seed, String levelname, int type) {
        this.randomSeed = seed;
        this.levelName = levelname;
        this.worldType = type;
    }

    public WorldInfo(WorldInfo worldinfo) {
        this.randomSeed = worldinfo.randomSeed;
        this.spawnX = worldinfo.spawnX;
        this.spawnY = worldinfo.spawnY;
        this.spawnZ = worldinfo.spawnZ;
        this.worldTime = worldinfo.worldTime;
        this.lastTimePlayed = worldinfo.lastTimePlayed;
        this.sizeOnDisk = worldinfo.sizeOnDisk;
        this.field_22195_h = worldinfo.field_22195_h;
        this.field_22194_i = worldinfo.field_22194_i;
        this.levelName = worldinfo.levelName;
        this.saveVersion = worldinfo.saveVersion;
        this.rainTime = worldinfo.rainTime;
        this.isRaining = worldinfo.isRaining;
        this.thunderTime = worldinfo.thunderTime;
        this.isThundering = worldinfo.isThundering;
        this.worldType = worldinfo.worldType;
    }

    public NBTTagCompound func_22185_a() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.saveNBTTag(nbttagcompound, this.field_22195_h);
        return nbttagcompound;
    }

    public NBTTagCompound func_22183_a(List list) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        EntityPlayer entityplayer = null;
        NBTTagCompound nbttagcompound1 = null;
        if (list.size() > 0) {
            entityplayer = (EntityPlayer)list.get(0);
        }
        if (entityplayer != null) {
            nbttagcompound1 = new NBTTagCompound();
            entityplayer.writeToNBT(nbttagcompound1);
        }
        this.saveNBTTag(nbttagcompound, nbttagcompound1);
        return nbttagcompound;
    }

    private void saveNBTTag(NBTTagCompound nbttagcompound, NBTTagCompound nbttagcompound1) {
        nbttagcompound.setLong("RandomSeed", this.randomSeed);
        nbttagcompound.setInteger("SpawnX", this.spawnX);
        nbttagcompound.setInteger("SpawnY", this.spawnY);
        nbttagcompound.setInteger("SpawnZ", this.spawnZ);
        nbttagcompound.setLong("Time", this.worldTime);
        nbttagcompound.setLong("SizeOnDisk", this.sizeOnDisk);
        nbttagcompound.setLong("LastPlayed", System.currentTimeMillis());
        nbttagcompound.setString("LevelName", this.levelName);
        nbttagcompound.setInteger("version", this.saveVersion);
        nbttagcompound.setInteger("rainTime", this.rainTime);
        nbttagcompound.setBoolean("raining", this.isRaining);
        nbttagcompound.setInteger("thunderTime", this.thunderTime);
        nbttagcompound.setBoolean("thundering", this.isThundering);
        nbttagcompound.setInteger("WorldType", this.worldType);
        if (nbttagcompound1 != null) {
            nbttagcompound.setCompoundTag("Player", nbttagcompound1);
        }
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public int getSpawnX() {
        return this.spawnX;
    }

    public int getSpawnY() {
        return this.spawnY;
    }

    public int getSpawnZ() {
        return this.spawnZ;
    }

    public long getWorldTime() {
        return this.worldTime;
    }

    public void setWorldType(int type) {
        this.worldType = type;
    }

    public int getWorldType() {
        return this.worldType;
    }

    public long getSizeOnDisk() {
        return this.sizeOnDisk;
    }

    public int getDimension() {
        return this.field_22194_i;
    }

    public void setWorldTime(long l) {
        this.worldTime = l;
    }

    public void setSizeOnDisk(long l) {
        this.sizeOnDisk = l;
    }

    public void setSpawnPosition(int i, int j, int k) {
        this.spawnX = i;
        this.spawnY = j;
        this.spawnZ = k;
    }

    public void setLevelName(String s) {
        this.levelName = s;
    }

    public int getVersion() {
        return this.saveVersion;
    }

    public void setVersion(int i) {
        this.saveVersion = i;
    }

    public boolean getIsThundering() {
        return this.isThundering;
    }

    public void setIsThundering(boolean flag) {
        this.isThundering = flag;
    }

    public int getThunderTime() {
        return this.thunderTime;
    }

    public void setThunderTime(int i) {
        this.thunderTime = i;
    }

    public boolean getIsRaining() {
        return this.isRaining;
    }

    public void setIsRaining(boolean flag) {
        this.isRaining = flag;
    }

    public int getRainTime() {
        return this.rainTime;
    }

    public void setRainTime(int i) {
        this.rainTime = i;
    }
}

