/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.server;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.ChunkProviderCorruption;
import com.mojang.minecraft.level.chunk.ChunkProviderDesert;
import com.mojang.minecraft.level.chunk.ChunkProviderGenerate;
import com.mojang.minecraft.level.chunk.ChunkProviderIndev;
import com.mojang.minecraft.level.chunk.ChunkProviderSky;
import com.mojang.minecraft.level.generate.IChunkProvider;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.server.WorldChunkManager;
import com.mojang.minecraft.server.WorldProviderHell;
import com.mojang.minecraft.server.WorldProviderSky;
import com.mojang.minecraft.server.WorldProviderSurface;
import java.util.HashMap;

public abstract class WorldProvider {
    public static final int NORMAL = 0;
    public static final int FLOATING = 1;
    public static final int CORRUPTION = 2;
    public static final int DESERT = 3;
    public static final int INDEV = 4;
    public static final HashMap<Integer, String> TYPENAMES = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(0, "NORMAL");
            this.put(1, "FLOATING");
            this.put(2, "CORRUPTION");
            this.put(3, "DESERT");
            this.put(4, "2D PERLIN");
        }
    };
    public World worldObj;
    public WorldChunkManager worldChunkMgr;
    public boolean field_6167_c = false;
    public boolean isHellWorld = false;
    public boolean field_4306_c = false;
    public float[] lightBrightnessTable = new float[16];
    public int worldType = 0;
    private float[] field_6164_h = new float[4];

    public final void registerWorld(World world) {
        this.worldObj = world;
        this.registerWorldChunkManager();
        this.generateLightBrightnessTable();
    }

    protected void generateLightBrightnessTable() {
        float f = 0.05f;
        int i = 0;
        while (i <= 15) {
            float f1 = 1.0f - (float)i / 15.0f;
            this.lightBrightnessTable[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
            ++i;
        }
    }

    protected void registerWorldChunkManager() {
        this.worldChunkMgr = new WorldChunkManager(this.worldObj);
    }

    public IChunkProvider getChunkProvider(int worldType) {
        if (worldType == 1) {
            return new ChunkProviderSky(this.worldObj, this.worldObj.getRandomSeed());
        }
        if (worldType == 2) {
            return new ChunkProviderCorruption(this.worldObj, this.worldObj.getRandomSeed());
        }
        if (worldType == 3) {
            return new ChunkProviderDesert(this.worldObj, this.worldObj.getRandomSeed());
        }
        if (worldType == 4) {
            return new ChunkProviderIndev(this.worldObj, this.worldObj.getRandomSeed());
        }
        return new ChunkProviderGenerate(this.worldObj, this.worldObj.getRandomSeed());
    }

    public boolean canCoordinateBeSpawn(int i, int j) {
        int k = this.worldObj.getFirstUncoveredBlock(i, j);
        if (this.worldType == 0 || this.worldType == 4) {
            return k == Block.sand.blockID;
        }
        return k == Block.grass.blockID;
    }

    public boolean func_28108_d() {
        return true;
    }

    public static WorldProvider func_4091_a(int i) {
        if (i == -1) {
            return new WorldProviderHell();
        }
        if (i == 0) {
            return new WorldProviderSurface();
        }
        if (i == 1) {
            return new WorldProviderSky();
        }
        return null;
    }
}

