/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.server;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityAnimal;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntityWaterMob;
import com.mojang.minecraft.entity.Explosion;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.ChunkProviderServer;
import com.mojang.minecraft.level.generate.IChunkLoader;
import com.mojang.minecraft.level.generate.IChunkProvider;
import com.mojang.minecraft.network.packet.Packet38EntityStatus;
import com.mojang.minecraft.network.packet.Packet54PlayNoteBlock;
import com.mojang.minecraft.network.packet.Packet60Explosion;
import com.mojang.minecraft.network.packet.Packet70Bed;
import com.mojang.minecraft.network.packet.Packet71Weather;
import com.mojang.minecraft.server.ISaveHandler;
import com.mojang.minecraft.server.MinecraftServer;
import com.mojang.minecraft.server.WorldProvider;
import com.mojang.minecraft.util.MCHash;
import com.mojang.minecraft.util.MathHelper;
import java.util.ArrayList;
import java.util.List;

public class WorldServer
extends World {
    public ChunkProviderServer chunkProviderServer;
    public boolean field_819_z = false;
    public boolean levelSaving;
    private MinecraftServer mcServer;
    private MCHash field_20912_E = new MCHash();

    public WorldServer(MinecraftServer minecraftserver, ISaveHandler isavehandler, String levelname, int i, long levelseed, String worldType, String levelSeason, String levelWeather) {
        super(isavehandler, levelname, levelseed, WorldProvider.func_4091_a(i), worldType, levelSeason, levelWeather);
        this.mcServer = minecraftserver;
    }

    public void updateEntityWithOptionalForce(Entity entity, boolean flag) {
        if (!this.mcServer.spawnPeacefulMobs && (entity instanceof EntityAnimal || entity instanceof EntityWaterMob)) {
            entity.setEntityDead();
        }
        if (entity.riddenByEntity == null || !(entity.riddenByEntity instanceof EntityPlayer)) {
            super.updateEntityWithOptionalForce(entity, flag);
        }
    }

    public void func_12017_b(Entity entity, boolean flag) {
        super.updateEntityWithOptionalForce(entity, flag);
    }

    protected IChunkProvider createChunkProvider() {
        int worldType = this.worldInfo.getWorldType();
        IChunkLoader ichunkloader = this.worldFile.func_22092_a(this.worldProvider);
        this.chunkProviderServer = new ChunkProviderServer(this, ichunkloader, this.worldProvider.getChunkProvider(worldType));
        return this.chunkProviderServer;
    }

    public List getTileEntityList(int i, int j, int k, int l, int i1, int j1) {
        ArrayList<TileEntity> arraylist = new ArrayList<TileEntity>();
        int k1 = 0;
        while (k1 < this.loadedTileEntityList.size()) {
            TileEntity tileentity = (TileEntity)this.loadedTileEntityList.get(k1);
            if (tileentity.xCoord >= i && tileentity.yCoord >= j && tileentity.zCoord >= k && tileentity.xCoord < l && tileentity.yCoord < i1 && tileentity.zCoord < j1) {
                arraylist.add(tileentity);
            }
            ++k1;
        }
        return arraylist;
    }

    public boolean canMineBlock(EntityPlayer entityplayer, int i, int j, int k) {
        int i1;
        int l = (int)MathHelper.abs(i - this.worldInfo.getSpawnX());
        if (l > (i1 = (int)MathHelper.abs(k - this.worldInfo.getSpawnZ()))) {
            i1 = l;
        }
        return i1 > 16 || this.mcServer.configManager.isOp(entityplayer.username);
    }

    protected void obtainEntitySkin(Entity entity) {
        super.obtainEntitySkin(entity);
        if (entity != null && this.field_20912_E != null) {
            this.field_20912_E.addKey(entity.entityId, entity);
        }
    }

    protected void releaseEntitySkin(Entity entity) {
        super.releaseEntitySkin(entity);
        this.field_20912_E.removeObject(entity.entityId);
    }

    public Entity func_6158_a(int i) {
        return (Entity)this.field_20912_E.lookup(i);
    }

    public boolean addLightningBolt(Entity entity) {
        if (super.addLightningBolt(entity)) {
            this.mcServer.configManager.sendPacketToPlayersAroundPoint(entity.posX, entity.posY, entity.posZ, 512.0, this.worldProvider.worldType, new Packet71Weather(entity));
            return true;
        }
        return false;
    }

    public void sendTrackedEntityStatusUpdatePacket(Entity entity, byte byte0) {
        Packet38EntityStatus packet38entitystatus = new Packet38EntityStatus(entity.entityId, byte0);
        this.mcServer.getEntityTracker(this.worldProvider.worldType).sendPacketToTrackedPlayersAndTrackedEntity(entity, packet38entitystatus);
    }

    public Explosion newExplosion(Entity entity, double d, double d1, double d2, float f, boolean flag) {
        Explosion explosion = new Explosion(this, entity, d, d1, d2, f);
        explosion.isFlaming = flag;
        explosion.doExplosion();
        explosion.doEffects(false);
        this.mcServer.configManager.sendPacketToPlayersAroundPoint(d, d1, d2, 64.0, this.worldProvider.worldType, new Packet60Explosion(d, d1, d2, f, explosion.destroyedBlockPositions));
        return explosion;
    }

    public void playNoteAt(int i, int j, int k, int l, int i1) {
        super.playNoteAt(i, j, k, l, i1);
        this.mcServer.configManager.sendPacketToPlayersAroundPoint(i, j, k, 64.0, this.worldProvider.worldType, new Packet54PlayNoteBlock(i, j, k, l, i1));
    }

    public void func_30006_w() {
        this.worldFile.func_22093_e();
    }

    protected void updateWeather() {
        boolean flag = this.func_27068_v();
        super.updateWeather();
        if (flag != this.func_27068_v()) {
            if (flag) {
                this.mcServer.configManager.sendPacketToAllPlayers(new Packet70Bed(2));
            } else {
                this.mcServer.configManager.sendPacketToAllPlayers(new Packet70Bed(1));
            }
        }
    }
}

