/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.util;

import com.mojang.minecraft.util.MCHashEntry;

public class MCHash {
    private transient MCHashEntry[] slots = new MCHashEntry[16];
    private transient int count;
    private int threshold = 12;
    private final float growFactor = 0.75f;
    private volatile transient int versionStamp;

    private static int computeHash(int i) {
        i ^= i >>> 20 ^ i >>> 12;
        return i ^ i >>> 7 ^ i >>> 4;
    }

    private static int getSlotIndex(int i, int j) {
        return i & j - 1;
    }

    public Object lookup(int i) {
        int j = MCHash.computeHash(i);
        MCHashEntry mchashentry = this.slots[MCHash.getSlotIndex(j, this.slots.length)];
        while (mchashentry != null) {
            if (mchashentry.hashEntry == i) {
                return mchashentry.valueEntry;
            }
            mchashentry = mchashentry.nextEntry;
        }
        return null;
    }

    public boolean containsItem(int i) {
        return this.lookupEntry(i) != null;
    }

    final MCHashEntry lookupEntry(int i) {
        int j = MCHash.computeHash(i);
        MCHashEntry mchashentry = this.slots[MCHash.getSlotIndex(j, this.slots.length)];
        while (mchashentry != null) {
            if (mchashentry.hashEntry == i) {
                return mchashentry;
            }
            mchashentry = mchashentry.nextEntry;
        }
        return null;
    }

    public void addKey(int i, Object obj) {
        int j = MCHash.computeHash(i);
        int k = MCHash.getSlotIndex(j, this.slots.length);
        MCHashEntry mchashentry = this.slots[k];
        while (mchashentry != null) {
            if (mchashentry.hashEntry == i) {
                mchashentry.valueEntry = obj;
            }
            mchashentry = mchashentry.nextEntry;
        }
        ++this.versionStamp;
        this.insert(j, i, obj, k);
    }

    private void grow(int i) {
        MCHashEntry[] amchashentry = this.slots;
        int j = amchashentry.length;
        if (j == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        MCHashEntry[] amchashentry1 = new MCHashEntry[i];
        this.copyTo(amchashentry1);
        this.slots = amchashentry1;
        this.threshold = (int)((float)i * 0.75f);
    }

    private void copyTo(MCHashEntry[] amchashentry) {
        MCHashEntry[] amchashentry1 = this.slots;
        int i = amchashentry.length;
        int j = 0;
        while (j < amchashentry1.length) {
            MCHashEntry mchashentry = amchashentry1[j];
            if (mchashentry != null) {
                MCHashEntry mchashentry1;
                amchashentry1[j] = null;
                do {
                    mchashentry1 = mchashentry.nextEntry;
                    int k = MCHash.getSlotIndex(mchashentry.slotHash, i);
                    mchashentry.nextEntry = amchashentry[k];
                    amchashentry[k] = mchashentry;
                } while ((mchashentry = mchashentry1) != null);
            }
            ++j;
        }
    }

    public Object removeObject(int i) {
        MCHashEntry mchashentry = this.removeEntry(i);
        return mchashentry != null ? mchashentry.valueEntry : null;
    }

    final MCHashEntry removeEntry(int i) {
        MCHashEntry mchashentry;
        int j = MCHash.computeHash(i);
        int k = MCHash.getSlotIndex(j, this.slots.length);
        MCHashEntry mchashentry1 = mchashentry = this.slots[k];
        while (mchashentry1 != null) {
            MCHashEntry mchashentry2 = mchashentry1.nextEntry;
            if (mchashentry1.hashEntry == i) {
                ++this.versionStamp;
                --this.count;
                if (mchashentry == mchashentry1) {
                    this.slots[k] = mchashentry2;
                } else {
                    mchashentry.nextEntry = mchashentry2;
                }
                return mchashentry1;
            }
            mchashentry = mchashentry1;
            mchashentry1 = mchashentry2;
        }
        return mchashentry1;
    }

    public void clearMap() {
        ++this.versionStamp;
        MCHashEntry[] amchashentry = this.slots;
        int i = 0;
        while (i < amchashentry.length) {
            amchashentry[i] = null;
            ++i;
        }
        this.count = 0;
    }

    private void insert(int i, int j, Object obj, int k) {
        MCHashEntry mchashentry = this.slots[k];
        this.slots[k] = new MCHashEntry(i, j, obj, mchashentry);
        if (this.count++ >= this.threshold) {
            this.grow(2 * this.slots.length);
        }
    }

    static int getHash(int i) {
        return MCHash.computeHash(i);
    }
}

